@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getResolverFirewallRuleGroupAssociation.
 * @property arn
 * @property creationTime
 * @property creatorRequestId
 * @property firewallRuleGroupAssociationId
 * @property firewallRuleGroupId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property managedOwnerName
 * @property modificationTime
 * @property mutationProtection
 * @property name
 * @property priority
 * @property status
 * @property statusMessage
 * @property vpcId
 */
public data class GetResolverFirewallRuleGroupAssociationResult(
    public val arn: String,
    public val creationTime: String,
    public val creatorRequestId: String,
    public val firewallRuleGroupAssociationId: String,
    public val firewallRuleGroupId: String,
    public val id: String,
    public val managedOwnerName: String,
    public val modificationTime: String,
    public val mutationProtection: String,
    public val name: String,
    public val priority: Int,
    public val status: String,
    public val statusMessage: String,
    public val vpcId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.route53.outputs.GetResolverFirewallRuleGroupAssociationResult):
            GetResolverFirewallRuleGroupAssociationResult =
            GetResolverFirewallRuleGroupAssociationResult(
                arn = javaType.arn(),
                creationTime = javaType.creationTime(),
                creatorRequestId = javaType.creatorRequestId(),
                firewallRuleGroupAssociationId = javaType.firewallRuleGroupAssociationId(),
                firewallRuleGroupId = javaType.firewallRuleGroupId(),
                id = javaType.id(),
                managedOwnerName = javaType.managedOwnerName(),
                modificationTime = javaType.modificationTime(),
                mutationProtection = javaType.mutationProtection(),
                name = javaType.name(),
                priority = javaType.priority(),
                status = javaType.status(),
                statusMessage = javaType.statusMessage(),
                vpcId = javaType.vpcId(),
            )
    }
}
