@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getResolverFirewallRuleGroup.
 * @property arn
 * @property creationTime
 * @property creatorRequestId
 * @property firewallRuleGroupId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property modificationTime
 * @property name
 * @property ownerId
 * @property ruleCount
 * @property shareStatus
 * @property status
 * @property statusMessage
 */
public data class GetResolverFirewallRuleGroupResult(
    public val arn: String,
    public val creationTime: String,
    public val creatorRequestId: String,
    public val firewallRuleGroupId: String,
    public val id: String,
    public val modificationTime: String,
    public val name: String,
    public val ownerId: String,
    public val ruleCount: Int,
    public val shareStatus: String,
    public val status: String,
    public val statusMessage: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.route53.outputs.GetResolverFirewallRuleGroupResult):
            GetResolverFirewallRuleGroupResult = GetResolverFirewallRuleGroupResult(
            arn = javaType.arn(),
            creationTime = javaType.creationTime(),
            creatorRequestId = javaType.creatorRequestId(),
            firewallRuleGroupId = javaType.firewallRuleGroupId(),
            id = javaType.id(),
            modificationTime = javaType.modificationTime(),
            name = javaType.name(),
            ownerId = javaType.ownerId(),
            ruleCount = javaType.ruleCount(),
            shareStatus = javaType.shareStatus(),
            status = javaType.status(),
            statusMessage = javaType.statusMessage(),
        )
    }
}
