@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id ID of an endpoint you want to assign.
 * @property region To route traffic to an Amazon S3 bucket that is configured as a website endpoint, specify the region in which you created the bucket for `region`.
 * @property type Type of the endpoint. Valid values are `value` , `cloudfront` , `elastic-load-balancer`, `s3-website`
 * @property value Value of the `type`.
 */
public data class GetTrafficPolicyDocumentEndpoint(
    public val id: String,
    public val region: String? = null,
    public val type: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.GetTrafficPolicyDocumentEndpoint):
            GetTrafficPolicyDocumentEndpoint = GetTrafficPolicyDocumentEndpoint(
            id = javaType.id(),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
