@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTrafficPolicyDocument.
 * @property endpoints
 * @property id The provider-assigned unique ID for this managed resource.
 * @property json Standard JSON policy document rendered based on the arguments above.
 * @property recordType
 * @property rules
 * @property startEndpoint
 * @property startRule
 * @property version
 */
public data class GetTrafficPolicyDocumentResult(
    public val endpoints: List<GetTrafficPolicyDocumentEndpoint>? = null,
    public val id: String,
    public val json: String,
    public val recordType: String? = null,
    public val rules: List<GetTrafficPolicyDocumentRule>? = null,
    public val startEndpoint: String? = null,
    public val startRule: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.GetTrafficPolicyDocumentResult):
            GetTrafficPolicyDocumentResult = GetTrafficPolicyDocumentResult(
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.route53.kotlin.outputs.GetTrafficPolicyDocumentEndpoint.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            json = javaType.json(),
            recordType = javaType.recordType().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.route53.kotlin.outputs.GetTrafficPolicyDocumentRule.Companion.toKotlin(args0)
                })
            }),
            startEndpoint = javaType.startEndpoint().map({ args0 -> args0 }).orElse(null),
            startRule = javaType.startRule().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
