@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property geoProximityLocations Configuration block for when you add a geoproximity rule, you configure Amazon Route 53 to route traffic to your resources based on the geographic location of your resources. Only valid for `geoproximity` type. See below
 * @property id ID of a rule you want to assign.
 * @property items Configuration block for when you add a multivalue answer rule, you configure your traffic policy to route traffic approximately randomly to your healthy resources.  Only valid for `multivalue` type. See below
 * @property locations Configuration block for when you add a geolocation rule, you configure your traffic policy to route your traffic based on the geographic location of your users.  Only valid for `geo` type. See below
 * @property primary Configuration block for the settings for the rule or endpoint that you want to route traffic to whenever the corresponding resources are available. Only valid for `failover` type. See below
 * @property regions To route traffic to an Amazon S3 bucket that is configured as a website endpoint, specify the region in which you created the bucket for `region`.
 * @property secondary Configuration block for the rule or endpoint that you want to route traffic to whenever the primary resources are not available. Only valid for `failover` type. See below
 * @property type Type of the rule.
 */
public data class GetTrafficPolicyDocumentRule(
    public val geoProximityLocations: List<GetTrafficPolicyDocumentRuleGeoProximityLocation>? = null,
    public val id: String,
    public val items: List<GetTrafficPolicyDocumentRuleItem>? = null,
    public val locations: List<GetTrafficPolicyDocumentRuleLocation>? = null,
    public val primary: GetTrafficPolicyDocumentRulePrimary? = null,
    public val regions: List<GetTrafficPolicyDocumentRuleRegion>? = null,
    public val secondary: GetTrafficPolicyDocumentRuleSecondary? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.GetTrafficPolicyDocumentRule):
            GetTrafficPolicyDocumentRule = GetTrafficPolicyDocumentRule(
            geoProximityLocations = javaType.geoProximityLocations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.route53.kotlin.outputs.GetTrafficPolicyDocumentRuleGeoProximityLocation.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            items = javaType.items().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.route53.kotlin.outputs.GetTrafficPolicyDocumentRuleItem.Companion.toKotlin(args0)
                })
            }),
            locations = javaType.locations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.route53.kotlin.outputs.GetTrafficPolicyDocumentRuleLocation.Companion.toKotlin(args0)
                })
            }),
            primary = javaType.primary().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.route53.kotlin.outputs.GetTrafficPolicyDocumentRulePrimary.Companion.toKotlin(args0)
                })
            }).orElse(null),
            regions = javaType.regions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.route53.kotlin.outputs.GetTrafficPolicyDocumentRuleRegion.Companion.toKotlin(args0)
                })
            }),
            secondary = javaType.secondary().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.route53.kotlin.outputs.GetTrafficPolicyDocumentRuleSecondary.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
