@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endpointReference References to an endpoint.
 * @property healthCheck If you want to associate a health check with the endpoint or rule.
 */
public data class GetTrafficPolicyDocumentRuleItem(
    public val endpointReference: String? = null,
    public val healthCheck: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.GetTrafficPolicyDocumentRuleItem):
            GetTrafficPolicyDocumentRuleItem = GetTrafficPolicyDocumentRuleItem(
            endpointReference = javaType.endpointReference().map({ args0 -> args0 }).orElse(null),
            healthCheck = javaType.healthCheck().map({ args0 -> args0 }).orElse(null),
        )
    }
}
