@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property continent Value of a continent.
 * @property country Value of a country.
 * @property endpointReference References to an endpoint.
 * @property evaluateTargetHealth Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
 * @property healthCheck If you want to associate a health check with the endpoint or rule.
 * @property isDefault Indicates whether this set of values represents the default location.
 * @property ruleReference References to a rule.
 * @property subdivision Value of a subdivision.
 */
public data class GetTrafficPolicyDocumentRuleLocation(
    public val continent: String? = null,
    public val country: String? = null,
    public val endpointReference: String? = null,
    public val evaluateTargetHealth: Boolean? = null,
    public val healthCheck: String? = null,
    public val isDefault: Boolean? = null,
    public val ruleReference: String? = null,
    public val subdivision: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.route53.outputs.GetTrafficPolicyDocumentRuleLocation):
            GetTrafficPolicyDocumentRuleLocation = GetTrafficPolicyDocumentRuleLocation(
            continent = javaType.continent().map({ args0 -> args0 }).orElse(null),
            country = javaType.country().map({ args0 -> args0 }).orElse(null),
            endpointReference = javaType.endpointReference().map({ args0 -> args0 }).orElse(null),
            evaluateTargetHealth = javaType.evaluateTargetHealth().map({ args0 -> args0 }).orElse(null),
            healthCheck = javaType.healthCheck().map({ args0 -> args0 }).orElse(null),
            isDefault = javaType.isDefault().map({ args0 -> args0 }).orElse(null),
            ruleReference = javaType.ruleReference().map({ args0 -> args0 }).orElse(null),
            subdivision = javaType.subdivision().map({ args0 -> args0 }).orElse(null),
        )
    }
}
