@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endpointReference References to an endpoint.
 * @property evaluateTargetHealth Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
 * @property healthCheck If you want to associate a health check with the endpoint or rule.
 * @property region Region code for the AWS Region that you created the resource in.
 * @property ruleReference References to a rule.
 */
public data class GetTrafficPolicyDocumentRuleRegion(
    public val endpointReference: String? = null,
    public val evaluateTargetHealth: Boolean? = null,
    public val healthCheck: String? = null,
    public val region: String? = null,
    public val ruleReference: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.route53.outputs.GetTrafficPolicyDocumentRuleRegion):
            GetTrafficPolicyDocumentRuleRegion = GetTrafficPolicyDocumentRuleRegion(
            endpointReference = javaType.endpointReference().map({ args0 -> args0 }).orElse(null),
            evaluateTargetHealth = javaType.evaluateTargetHealth().map({ args0 -> args0 }).orElse(null),
            healthCheck = javaType.healthCheck().map({ args0 -> args0 }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            ruleReference = javaType.ruleReference().map({ args0 -> args0 }).orElse(null),
        )
    }
}
