@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getZone.
 * @property arn ARN of the Hosted Zone.
 * @property callerReference Caller Reference of the Hosted Zone.
 * @property comment Comment field of the Hosted Zone.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property linkedServiceDescription The description provided by the service that created the Hosted Zone (e.g., `arn:aws:servicediscovery:us-east-1:1234567890:namespace/ns-xxxxxxxxxxxxxxxx`).
 * @property linkedServicePrincipal The service that created the Hosted Zone (e.g., `servicediscovery.amazonaws.com`).
 * @property name
 * @property nameServers List of DNS name servers for the Hosted Zone.
 * @property primaryNameServer The Route 53 name server that created the SOA record.
 * @property privateZone
 * @property resourceRecordSetCount The number of Record Set in the Hosted Zone.
 * @property tags
 * @property vpcId
 * @property zoneId
 */
public data class GetZoneResult(
    public val arn: String,
    public val callerReference: String,
    public val comment: String,
    public val id: String,
    public val linkedServiceDescription: String,
    public val linkedServicePrincipal: String,
    public val name: String,
    public val nameServers: List<String>,
    public val primaryNameServer: String,
    public val privateZone: Boolean? = null,
    public val resourceRecordSetCount: Int,
    public val tags: Map<String, String>,
    public val vpcId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.GetZoneResult): GetZoneResult =
            GetZoneResult(
                arn = javaType.arn(),
                callerReference = javaType.callerReference(),
                comment = javaType.comment(),
                id = javaType.id(),
                linkedServiceDescription = javaType.linkedServiceDescription(),
                linkedServicePrincipal = javaType.linkedServicePrincipal(),
                name = javaType.name(),
                nameServers = javaType.nameServers().map({ args0 -> args0 }),
                primaryNameServer = javaType.primaryNameServer(),
                privateZone = javaType.privateZone().map({ args0 -> args0 }).orElse(null),
                resourceRecordSetCount = javaType.resourceRecordSetCount(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                vpcId = javaType.vpcId(),
                zoneId = javaType.zoneId(),
            )
    }
}
