@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property evaluateTargetHealth Set to `true` if you want Route 53 to determine whether to respond to DNS queries using this resource record set by checking the health of the resource record set. Some resources have special requirements, see [related part of documentation](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resource-record-sets-values.html#rrsets-values-alias-evaluate-target-health).
 * @property name DNS domain name for a CloudFront distribution, S3 bucket, ELB, or another resource record set in this hosted zone.
 * @property zoneId Hosted zone ID for a CloudFront distribution, S3 bucket, ELB, or Route 53 hosted zone. See `resource_elb.zone_id` for example.
 */
public data class RecordAlias(
    public val evaluateTargetHealth: Boolean,
    public val name: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.RecordAlias): RecordAlias =
            RecordAlias(
                evaluateTargetHealth = javaType.evaluateTargetHealth(),
                name = javaType.name(),
                zoneId = javaType.zoneId(),
            )
    }
}
