@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property collectionId The CIDR collection ID. See the `aws.route53.CidrCollection` resource for more details.
 * @property locationName The CIDR collection location name. See the `aws.route53.CidrLocation` resource for more details. A `location_name` with an asterisk `"*"` can be used to create a default CIDR record. `collection_id` is still required for default record.
 */
public data class RecordCidrRoutingPolicy(
    public val collectionId: String,
    public val locationName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.RecordCidrRoutingPolicy):
            RecordCidrRoutingPolicy = RecordCidrRoutingPolicy(
            collectionId = javaType.collectionId(),
            locationName = javaType.locationName(),
        )
    }
}
