@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property type `PRIMARY` or `SECONDARY`. A `PRIMARY` record will be served if its healthcheck is passing, otherwise the `SECONDARY` will be served. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html#dns-failover-failover-rrsets
 */
public data class RecordFailoverRoutingPolicy(
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.RecordFailoverRoutingPolicy):
            RecordFailoverRoutingPolicy = RecordFailoverRoutingPolicy(
            type = javaType.type(),
        )
    }
}
