@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ip The IP address in the subnet that you want to use for DNS queries.
 * @property ipId
 * @property subnetId The ID of the subnet that contains the IP address.
 */
public data class ResolverEndpointIpAddress(
    public val ip: String? = null,
    public val ipId: String? = null,
    public val subnetId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.ResolverEndpointIpAddress):
            ResolverEndpointIpAddress = ResolverEndpointIpAddress(
            ip = javaType.ip().map({ args0 -> args0 }).orElse(null),
            ipId = javaType.ipId().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId(),
        )
    }
}
