@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53domains.kotlin.inputs

import com.pulumi.aws.route53domains.inputs.RegisteredDomainAdminContactArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property addressLine1 First line of the contact's address.
 * @property addressLine2 Second line of contact's address, if any.
 * @property city The city of the contact's address.
 * @property contactType Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
 * @property countryCode Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
 * @property email Email address of the contact.
 * @property extraParams A key-value map of parameters required by certain top-level domains.
 * @property fax Fax number of the contact. Phone number must be specified in the format "+[country dialing code]&#46;[number including any area code]".
 * @property firstName First name of contact.
 * @property lastName Last name of contact.
 * @property organizationName Name of the organization for contact types other than `PERSON`.
 * @property phoneNumber The phone number of the contact. Phone number must be specified in the format "+[country dialing code]&#46;[number including any area code]".
 * @property state The state or province of the contact's city.
 * @property zipCode The zip or postal code of the contact's address.
 */
public data class RegisteredDomainAdminContactArgs(
    public val addressLine1: Output<String>? = null,
    public val addressLine2: Output<String>? = null,
    public val city: Output<String>? = null,
    public val contactType: Output<String>? = null,
    public val countryCode: Output<String>? = null,
    public val email: Output<String>? = null,
    public val extraParams: Output<Map<String, String>>? = null,
    public val fax: Output<String>? = null,
    public val firstName: Output<String>? = null,
    public val lastName: Output<String>? = null,
    public val organizationName: Output<String>? = null,
    public val phoneNumber: Output<String>? = null,
    public val state: Output<String>? = null,
    public val zipCode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53domains.inputs.RegisteredDomainAdminContactArgs> {
    override fun toJava(): com.pulumi.aws.route53domains.inputs.RegisteredDomainAdminContactArgs =
        com.pulumi.aws.route53domains.inputs.RegisteredDomainAdminContactArgs.builder()
            .addressLine1(addressLine1?.applyValue({ args0 -> args0 }))
            .addressLine2(addressLine2?.applyValue({ args0 -> args0 }))
            .city(city?.applyValue({ args0 -> args0 }))
            .contactType(contactType?.applyValue({ args0 -> args0 }))
            .countryCode(countryCode?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .extraParams(
                extraParams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .fax(fax?.applyValue({ args0 -> args0 }))
            .firstName(firstName?.applyValue({ args0 -> args0 }))
            .lastName(lastName?.applyValue({ args0 -> args0 }))
            .organizationName(organizationName?.applyValue({ args0 -> args0 }))
            .phoneNumber(phoneNumber?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 }))
            .zipCode(zipCode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegisteredDomainAdminContactArgs].
 */
@PulumiTagMarker
public class RegisteredDomainAdminContactArgsBuilder internal constructor() {
    private var addressLine1: Output<String>? = null

    private var addressLine2: Output<String>? = null

    private var city: Output<String>? = null

    private var contactType: Output<String>? = null

    private var countryCode: Output<String>? = null

    private var email: Output<String>? = null

    private var extraParams: Output<Map<String, String>>? = null

    private var fax: Output<String>? = null

    private var firstName: Output<String>? = null

    private var lastName: Output<String>? = null

    private var organizationName: Output<String>? = null

    private var phoneNumber: Output<String>? = null

    private var state: Output<String>? = null

    private var zipCode: Output<String>? = null

    /**
     * @param value First line of the contact's address.
     */
    @JvmName("eovyqqhcivccxddt")
    public suspend fun addressLine1(`value`: Output<String>) {
        this.addressLine1 = value
    }

    /**
     * @param value Second line of contact's address, if any.
     */
    @JvmName("lghonvwlursvlwcj")
    public suspend fun addressLine2(`value`: Output<String>) {
        this.addressLine2 = value
    }

    /**
     * @param value The city of the contact's address.
     */
    @JvmName("clwnwkcyyjdkfpjp")
    public suspend fun city(`value`: Output<String>) {
        this.city = value
    }

    /**
     * @param value Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
     */
    @JvmName("ybfexudlhuwxnran")
    public suspend fun contactType(`value`: Output<String>) {
        this.contactType = value
    }

    /**
     * @param value Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
     */
    @JvmName("tavaftrkltoqsagh")
    public suspend fun countryCode(`value`: Output<String>) {
        this.countryCode = value
    }

    /**
     * @param value Email address of the contact.
     */
    @JvmName("aotocecbteacuafu")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value A key-value map of parameters required by certain top-level domains.
     */
    @JvmName("tmodvyghrcmhnreq")
    public suspend fun extraParams(`value`: Output<Map<String, String>>) {
        this.extraParams = value
    }

    /**
     * @param value Fax number of the contact. Phone number must be specified in the format "+[country dialing code]&#46;[number including any area code]".
     */
    @JvmName("kptacxyceipksjsg")
    public suspend fun fax(`value`: Output<String>) {
        this.fax = value
    }

    /**
     * @param value First name of contact.
     */
    @JvmName("fnuytwdvpxuhddyu")
    public suspend fun firstName(`value`: Output<String>) {
        this.firstName = value
    }

    /**
     * @param value Last name of contact.
     */
    @JvmName("geokgqgguveafhwf")
    public suspend fun lastName(`value`: Output<String>) {
        this.lastName = value
    }

    /**
     * @param value Name of the organization for contact types other than `PERSON`.
     */
    @JvmName("qyhwlcgfcefmeqjl")
    public suspend fun organizationName(`value`: Output<String>) {
        this.organizationName = value
    }

    /**
     * @param value The phone number of the contact. Phone number must be specified in the format "+[country dialing code]&#46;[number including any area code]".
     */
    @JvmName("jpgowxdxeunurhxh")
    public suspend fun phoneNumber(`value`: Output<String>) {
        this.phoneNumber = value
    }

    /**
     * @param value The state or province of the contact's city.
     */
    @JvmName("jcyxodxvaojdkksj")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value The zip or postal code of the contact's address.
     */
    @JvmName("bfqeoqkgdjcdxpgw")
    public suspend fun zipCode(`value`: Output<String>) {
        this.zipCode = value
    }

    /**
     * @param value First line of the contact's address.
     */
    @JvmName("dmrxntcoypgifvqh")
    public suspend fun addressLine1(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressLine1 = mapped
    }

    /**
     * @param value Second line of contact's address, if any.
     */
    @JvmName("qdaixoqhnwnemyey")
    public suspend fun addressLine2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressLine2 = mapped
    }

    /**
     * @param value The city of the contact's address.
     */
    @JvmName("xhoujgfmugejpabg")
    public suspend fun city(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.city = mapped
    }

    /**
     * @param value Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
     */
    @JvmName("vwkxsvialicwnbhl")
    public suspend fun contactType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactType = mapped
    }

    /**
     * @param value Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
     */
    @JvmName("mlnlxbslnvsledwc")
    public suspend fun countryCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.countryCode = mapped
    }

    /**
     * @param value Email address of the contact.
     */
    @JvmName("eahaesnxnhlwdpjj")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value A key-value map of parameters required by certain top-level domains.
     */
    @JvmName("mmrhvdredrqyxlmg")
    public suspend fun extraParams(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extraParams = mapped
    }

    /**
     * @param values A key-value map of parameters required by certain top-level domains.
     */
    @JvmName("laejrdwjukigqxck")
    public fun extraParams(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extraParams = mapped
    }

    /**
     * @param value Fax number of the contact. Phone number must be specified in the format "+[country dialing code]&#46;[number including any area code]".
     */
    @JvmName("kiixwvdmqiyjgdsf")
    public suspend fun fax(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fax = mapped
    }

    /**
     * @param value First name of contact.
     */
    @JvmName("qidlifjnrckfflmc")
    public suspend fun firstName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstName = mapped
    }

    /**
     * @param value Last name of contact.
     */
    @JvmName("wupplvgpcewkoorf")
    public suspend fun lastName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastName = mapped
    }

    /**
     * @param value Name of the organization for contact types other than `PERSON`.
     */
    @JvmName("earoykusaibdotdl")
    public suspend fun organizationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationName = mapped
    }

    /**
     * @param value The phone number of the contact. Phone number must be specified in the format "+[country dialing code]&#46;[number including any area code]".
     */
    @JvmName("pxihtjdcfarghfin")
    public suspend fun phoneNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneNumber = mapped
    }

    /**
     * @param value The state or province of the contact's city.
     */
    @JvmName("cvpbvcetdaykjpdk")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The zip or postal code of the contact's address.
     */
    @JvmName("yaabaynpbkrlfmgu")
    public suspend fun zipCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zipCode = mapped
    }

    internal fun build(): RegisteredDomainAdminContactArgs = RegisteredDomainAdminContactArgs(
        addressLine1 = addressLine1,
        addressLine2 = addressLine2,
        city = city,
        contactType = contactType,
        countryCode = countryCode,
        email = email,
        extraParams = extraParams,
        fax = fax,
        firstName = firstName,
        lastName = lastName,
        organizationName = organizationName,
        phoneNumber = phoneNumber,
        state = state,
        zipCode = zipCode,
    )
}
