@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53domains.kotlin.inputs

import com.pulumi.aws.route53domains.inputs.RegisteredDomainNameServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property glueIps Glue IP addresses of a name server. The list can contain only one IPv4 and one IPv6 address.
 * @property name The fully qualified host name of the name server.
 */
public data class RegisteredDomainNameServerArgs(
    public val glueIps: Output<List<String>>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.route53domains.inputs.RegisteredDomainNameServerArgs> {
    override fun toJava(): com.pulumi.aws.route53domains.inputs.RegisteredDomainNameServerArgs =
        com.pulumi.aws.route53domains.inputs.RegisteredDomainNameServerArgs.builder()
            .glueIps(glueIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegisteredDomainNameServerArgs].
 */
@PulumiTagMarker
public class RegisteredDomainNameServerArgsBuilder internal constructor() {
    private var glueIps: Output<List<String>>? = null

    private var name: Output<String>? = null

    /**
     * @param value Glue IP addresses of a name server. The list can contain only one IPv4 and one IPv6 address.
     */
    @JvmName("scpshpairmmutbua")
    public suspend fun glueIps(`value`: Output<List<String>>) {
        this.glueIps = value
    }

    @JvmName("usphyxcokinokpfp")
    public suspend fun glueIps(vararg values: Output<String>) {
        this.glueIps = Output.all(values.asList())
    }

    /**
     * @param values Glue IP addresses of a name server. The list can contain only one IPv4 and one IPv6 address.
     */
    @JvmName("xyjkjkjclfiwoncp")
    public suspend fun glueIps(values: List<Output<String>>) {
        this.glueIps = Output.all(values)
    }

    /**
     * @param value The fully qualified host name of the name server.
     */
    @JvmName("jfnysomkognvjyam")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Glue IP addresses of a name server. The list can contain only one IPv4 and one IPv6 address.
     */
    @JvmName("pstdpvlkhrqvvqip")
    public suspend fun glueIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.glueIps = mapped
    }

    /**
     * @param values Glue IP addresses of a name server. The list can contain only one IPv4 and one IPv6 address.
     */
    @JvmName("shsfewbknajrgckd")
    public suspend fun glueIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.glueIps = mapped
    }

    /**
     * @param value The fully qualified host name of the name server.
     */
    @JvmName("rxumhcdptythuxtv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): RegisteredDomainNameServerArgs = RegisteredDomainNameServerArgs(
        glueIps = glueIps,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
