@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53domains.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property addressLine1 First line of the contact's address.
 * @property addressLine2 Second line of contact's address, if any.
 * @property city The city of the contact's address.
 * @property contactType Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
 * @property countryCode Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
 * @property email Email address of the contact.
 * @property extraParams A key-value map of parameters required by certain top-level domains.
 * @property fax Fax number of the contact. Phone number must be specified in the format "+[country dialing code]&#46;[number including any area code]".
 * @property firstName First name of contact.
 * @property lastName Last name of contact.
 * @property organizationName Name of the organization for contact types other than `PERSON`.
 * @property phoneNumber The phone number of the contact. Phone number must be specified in the format "+[country dialing code]&#46;[number including any area code]".
 * @property state The state or province of the contact's city.
 * @property zipCode The zip or postal code of the contact's address.
 */
public data class RegisteredDomainAdminContact(
    public val addressLine1: String? = null,
    public val addressLine2: String? = null,
    public val city: String? = null,
    public val contactType: String? = null,
    public val countryCode: String? = null,
    public val email: String? = null,
    public val extraParams: Map<String, String>? = null,
    public val fax: String? = null,
    public val firstName: String? = null,
    public val lastName: String? = null,
    public val organizationName: String? = null,
    public val phoneNumber: String? = null,
    public val state: String? = null,
    public val zipCode: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.route53domains.outputs.RegisteredDomainAdminContact):
            RegisteredDomainAdminContact = RegisteredDomainAdminContact(
            addressLine1 = javaType.addressLine1().map({ args0 -> args0 }).orElse(null),
            addressLine2 = javaType.addressLine2().map({ args0 -> args0 }).orElse(null),
            city = javaType.city().map({ args0 -> args0 }).orElse(null),
            contactType = javaType.contactType().map({ args0 -> args0 }).orElse(null),
            countryCode = javaType.countryCode().map({ args0 -> args0 }).orElse(null),
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            extraParams = javaType.extraParams().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            fax = javaType.fax().map({ args0 -> args0 }).orElse(null),
            firstName = javaType.firstName().map({ args0 -> args0 }).orElse(null),
            lastName = javaType.lastName().map({ args0 -> args0 }).orElse(null),
            organizationName = javaType.organizationName().map({ args0 -> args0 }).orElse(null),
            phoneNumber = javaType.phoneNumber().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            zipCode = javaType.zipCode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
