@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoverycontrol.kotlin

import com.pulumi.aws.route53recoverycontrol.ClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AWS Route 53 Recovery Control Config Cluster.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53recoverycontrol.Cluster;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cluster("example");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 Recovery Control Config cluster using the cluster ARN. For example:
 * ```sh
 *  $ pulumi import aws:route53recoverycontrol/cluster:Cluster mycluster arn:aws:route53-recovery-control::313517334327:cluster/f9ae13be-a11e-4ec7-8522-94a70468e6ea
 * ```
 * @property name Unique name describing the cluster.
 */
public data class ClusterArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53recoverycontrol.ClusterArgs> {
    override fun toJava(): com.pulumi.aws.route53recoverycontrol.ClusterArgs =
        com.pulumi.aws.route53recoverycontrol.ClusterArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Unique name describing the cluster.
     */
    @JvmName("pfqwatdhmwkwnvnb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Unique name describing the cluster.
     */
    @JvmName("frjhtewvutumwyxm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        name = name,
    )
}
