@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoverycontrol.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ControlPanel].
 */
@PulumiTagMarker
public class ControlPanelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ControlPanelArgs = ControlPanelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ControlPanelArgsBuilder.() -> Unit) {
        val builder = ControlPanelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ControlPanel {
        val builtJavaResource =
            com.pulumi.aws.route53recoverycontrol.ControlPanel(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ControlPanel(builtJavaResource)
    }
}

/**
 * Provides an AWS Route 53 Recovery Control Config Control Panel.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53recoverycontrol.ControlPanel;
 * import com.pulumi.aws.route53recoverycontrol.ControlPanelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ControlPanel("example", ControlPanelArgs.builder()
 *             .clusterArn("arn:aws:route53-recovery-control::123456789012:cluster/8d47920e-d789-437d-803a-2dcc4b204393")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 Recovery Control Config Control Panel using the control panel arn. For example:
 * ```sh
 *  $ pulumi import aws:route53recoverycontrol/controlPanel:ControlPanel mypanel arn:aws:route53-recovery-control::313517334327:controlpanel/1bfba17df8684f5dab0467b71424f7e8
 * ```
 *
 */
public class ControlPanel internal constructor(
    override val javaResource: com.pulumi.aws.route53recoverycontrol.ControlPanel,
) : KotlinCustomResource(javaResource, ControlPanelMapper) {
    /**
     * ARN of the control panel.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * ARN of the cluster in which this control panel will reside.
     */
    public val clusterArn: Output<String>
        get() = javaResource.clusterArn().applyValue({ args0 -> args0 })

    /**
     * Whether a control panel is default.
     */
    public val defaultControlPanel: Output<Boolean>
        get() = javaResource.defaultControlPanel().applyValue({ args0 -> args0 })

    /**
     * Name describing the control panel.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Number routing controls in a control panel.
     */
    public val routingControlCount: Output<Int>
        get() = javaResource.routingControlCount().applyValue({ args0 -> args0 })

    /**
     * Status of control panel: `PENDING` when it is being created/updated, `PENDING_DELETION` when it is being deleted, and `DEPLOYED` otherwise.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ControlPanelMapper : ResourceMapper<ControlPanel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53recoverycontrol.ControlPanel::class == javaResource::class

    override fun map(javaResource: Resource): ControlPanel = ControlPanel(
        javaResource as
            com.pulumi.aws.route53recoverycontrol.ControlPanel,
    )
}

/**
 * @see [ControlPanel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ControlPanel].
 */
public suspend fun controlPanel(
    name: String,
    block: suspend ControlPanelResourceBuilder.() -> Unit,
): ControlPanel {
    val builder = ControlPanelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ControlPanel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun controlPanel(name: String): ControlPanel {
    val builder = ControlPanelResourceBuilder()
    builder.name(name)
    return builder.build()
}
