@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoverycontrol.kotlin

import com.pulumi.aws.route53recoverycontrol.ControlPanelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AWS Route 53 Recovery Control Config Control Panel.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53recoverycontrol.ControlPanel;
 * import com.pulumi.aws.route53recoverycontrol.ControlPanelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ControlPanel("example", ControlPanelArgs.builder()
 *             .clusterArn("arn:aws:route53-recovery-control::123456789012:cluster/8d47920e-d789-437d-803a-2dcc4b204393")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 Recovery Control Config Control Panel using the control panel arn. For example:
 * ```sh
 *  $ pulumi import aws:route53recoverycontrol/controlPanel:ControlPanel mypanel arn:aws:route53-recovery-control::313517334327:controlpanel/1bfba17df8684f5dab0467b71424f7e8
 * ```
 * @property clusterArn ARN of the cluster in which this control panel will reside.
 * @property name Name describing the control panel.
 */
public data class ControlPanelArgs(
    public val clusterArn: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53recoverycontrol.ControlPanelArgs> {
    override fun toJava(): com.pulumi.aws.route53recoverycontrol.ControlPanelArgs =
        com.pulumi.aws.route53recoverycontrol.ControlPanelArgs.builder()
            .clusterArn(clusterArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ControlPanelArgs].
 */
@PulumiTagMarker
public class ControlPanelArgsBuilder internal constructor() {
    private var clusterArn: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value ARN of the cluster in which this control panel will reside.
     */
    @JvmName("slmmxphdpanmyrcq")
    public suspend fun clusterArn(`value`: Output<String>) {
        this.clusterArn = value
    }

    /**
     * @param value Name describing the control panel.
     */
    @JvmName("mfhkhlayregtalya")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ARN of the cluster in which this control panel will reside.
     */
    @JvmName("xsrsmtwwucdvpxft")
    public suspend fun clusterArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterArn = mapped
    }

    /**
     * @param value Name describing the control panel.
     */
    @JvmName("dkprjanargivbicc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ControlPanelArgs = ControlPanelArgs(
        clusterArn = clusterArn,
        name = name,
    )
}
