@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoverycontrol.kotlin

import com.pulumi.aws.route53recoverycontrol.RoutingControlArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AWS Route 53 Recovery Control Config Routing Control.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53recoverycontrol.RoutingControl;
 * import com.pulumi.aws.route53recoverycontrol.RoutingControlArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RoutingControl("example", RoutingControlArgs.builder()
 *             .clusterArn("arn:aws:route53-recovery-control::881188118811:cluster/8d47920e-d789-437d-803a-2dcc4b204393")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 Recovery Control Config Routing Control using the routing control arn. For example:
 * ```sh
 *  $ pulumi import aws:route53recoverycontrol/routingControl:RoutingControl mycontrol arn:aws:route53-recovery-control::313517334327:controlpanel/abd5fbfc052d4844a082dbf400f61da8/routingcontrol/d5d90e587870494b
 * ```
 * @property clusterArn ARN of the cluster in which this routing control will reside.
 * @property controlPanelArn ARN of the control panel in which this routing control will reside.
 * @property name The name describing the routing control.
 * The following arguments are optional:
 */
public data class RoutingControlArgs(
    public val clusterArn: Output<String>? = null,
    public val controlPanelArn: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53recoverycontrol.RoutingControlArgs> {
    override fun toJava(): com.pulumi.aws.route53recoverycontrol.RoutingControlArgs =
        com.pulumi.aws.route53recoverycontrol.RoutingControlArgs.builder()
            .clusterArn(clusterArn?.applyValue({ args0 -> args0 }))
            .controlPanelArn(controlPanelArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoutingControlArgs].
 */
@PulumiTagMarker
public class RoutingControlArgsBuilder internal constructor() {
    private var clusterArn: Output<String>? = null

    private var controlPanelArn: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value ARN of the cluster in which this routing control will reside.
     */
    @JvmName("vysgkfhpaebisxfd")
    public suspend fun clusterArn(`value`: Output<String>) {
        this.clusterArn = value
    }

    /**
     * @param value ARN of the control panel in which this routing control will reside.
     */
    @JvmName("gttbbabhcowetahb")
    public suspend fun controlPanelArn(`value`: Output<String>) {
        this.controlPanelArn = value
    }

    /**
     * @param value The name describing the routing control.
     * The following arguments are optional:
     */
    @JvmName("faoryikolpkivmob")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ARN of the cluster in which this routing control will reside.
     */
    @JvmName("orjnblrexiwyffbf")
    public suspend fun clusterArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterArn = mapped
    }

    /**
     * @param value ARN of the control panel in which this routing control will reside.
     */
    @JvmName("fbfdcasaigwnhnpe")
    public suspend fun controlPanelArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlPanelArn = mapped
    }

    /**
     * @param value The name describing the routing control.
     * The following arguments are optional:
     */
    @JvmName("vfogodsywkiktiqv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): RoutingControlArgs = RoutingControlArgs(
        clusterArn = clusterArn,
        controlPanelArn = controlPanelArn,
        name = name,
    )
}
