@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoverycontrol.kotlin

import com.pulumi.aws.route53recoverycontrol.kotlin.outputs.SafetyRuleRuleConfig
import com.pulumi.aws.route53recoverycontrol.kotlin.outputs.SafetyRuleRuleConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SafetyRule].
 */
@PulumiTagMarker
public class SafetyRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SafetyRuleArgs = SafetyRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SafetyRuleArgsBuilder.() -> Unit) {
        val builder = SafetyRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SafetyRule {
        val builtJavaResource =
            com.pulumi.aws.route53recoverycontrol.SafetyRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SafetyRule(builtJavaResource)
    }
}

/**
 * Provides an AWS Route 53 Recovery Control Config Safety Rule
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53recoverycontrol.SafetyRule;
 * import com.pulumi.aws.route53recoverycontrol.SafetyRuleArgs;
 * import com.pulumi.aws.route53recoverycontrol.inputs.SafetyRuleRuleConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SafetyRule("example", SafetyRuleArgs.builder()
 *             .assertedControls(aws_route53recoverycontrolconfig_routing_control.example().arn())
 *             .controlPanelArn("arn:aws:route53-recovery-control::313517334327:controlpanel/abd5fbfc052d4844a082dbf400f61da8")
 *             .waitPeriodMs(5000)
 *             .ruleConfig(SafetyRuleRuleConfigArgs.builder()
 *                 .inverted(false)
 *                 .threshold(1)
 *                 .type("ATLEAST")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 Recovery Control Config Safety Rule using the safety rule ARN. For example:
 * ```sh
 *  $ pulumi import aws:route53recoverycontrol/safetyRule:SafetyRule myrule arn:aws:route53-recovery-control::313517334327:controlpanel/1bfba17df8684f5dab0467b71424f7e8/safetyrule/3bacc77003364c0f
 * ```
 *
 */
public class SafetyRule internal constructor(
    override val javaResource: com.pulumi.aws.route53recoverycontrol.SafetyRule,
) : KotlinCustomResource(javaResource, SafetyRuleMapper) {
    /**
     * ARN of the safety rule.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed.
     */
    public val assertedControls: Output<List<String>>?
        get() = javaResource.assertedControls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * ARN of the control panel in which this safety rule will reside.
     */
    public val controlPanelArn: Output<String>
        get() = javaResource.controlPanelArn().applyValue({ args0 -> args0 })

    /**
     * Gating controls for the new gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.
     */
    public val gatingControls: Output<List<String>>?
        get() = javaResource.gatingControls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Name describing the safety rule.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configuration block for safety rule criteria. See below.
     */
    public val ruleConfig: Output<SafetyRuleRuleConfig>
        get() = javaResource.ruleConfig().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Status of the safety rule. `PENDING` when it is being created/updated, `PENDING_DELETION` when it is being deleted, and `DEPLOYED` otherwise.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Routing controls that can only be set or unset if the specified `rule_config` evaluates to true for the specified `gating_controls`.
     */
    public val targetControls: Output<List<String>>?
        get() = javaResource.targetControls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail.
     * The following arguments are optional:
     */
    public val waitPeriodMs: Output<Int>
        get() = javaResource.waitPeriodMs().applyValue({ args0 -> args0 })
}

public object SafetyRuleMapper : ResourceMapper<SafetyRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53recoverycontrol.SafetyRule::class == javaResource::class

    override fun map(javaResource: Resource): SafetyRule = SafetyRule(
        javaResource as
            com.pulumi.aws.route53recoverycontrol.SafetyRule,
    )
}

/**
 * @see [SafetyRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SafetyRule].
 */
public suspend fun safetyRule(name: String, block: suspend SafetyRuleResourceBuilder.() -> Unit):
    SafetyRule {
    val builder = SafetyRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SafetyRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun safetyRule(name: String): SafetyRule {
    val builder = SafetyRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
