@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoverycontrol.kotlin.inputs

import com.pulumi.aws.route53recoverycontrol.inputs.SafetyRuleRuleConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property inverted Logical negation of the rule.
 * @property threshold Number of controls that must be set when you specify an `ATLEAST` type rule.
 * @property type Rule type. Valid values are `ATLEAST`, `AND`, and `OR`.
 */
public data class SafetyRuleRuleConfigArgs(
    public val inverted: Output<Boolean>,
    public val threshold: Output<Int>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.route53recoverycontrol.inputs.SafetyRuleRuleConfigArgs> {
    override fun toJava(): com.pulumi.aws.route53recoverycontrol.inputs.SafetyRuleRuleConfigArgs =
        com.pulumi.aws.route53recoverycontrol.inputs.SafetyRuleRuleConfigArgs.builder()
            .inverted(inverted.applyValue({ args0 -> args0 }))
            .threshold(threshold.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SafetyRuleRuleConfigArgs].
 */
@PulumiTagMarker
public class SafetyRuleRuleConfigArgsBuilder internal constructor() {
    private var inverted: Output<Boolean>? = null

    private var threshold: Output<Int>? = null

    private var type: Output<String>? = null

    /**
     * @param value Logical negation of the rule.
     */
    @JvmName("lykvlmtgulttipmg")
    public suspend fun inverted(`value`: Output<Boolean>) {
        this.inverted = value
    }

    /**
     * @param value Number of controls that must be set when you specify an `ATLEAST` type rule.
     */
    @JvmName("rcaitcqcbboogjfl")
    public suspend fun threshold(`value`: Output<Int>) {
        this.threshold = value
    }

    /**
     * @param value Rule type. Valid values are `ATLEAST`, `AND`, and `OR`.
     */
    @JvmName("opodevjlsqpcnbio")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Logical negation of the rule.
     */
    @JvmName("jchsgiduukavvbck")
    public suspend fun inverted(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inverted = mapped
    }

    /**
     * @param value Number of controls that must be set when you specify an `ATLEAST` type rule.
     */
    @JvmName("xyeooreaxittwwqu")
    public suspend fun threshold(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    /**
     * @param value Rule type. Valid values are `ATLEAST`, `AND`, and `OR`.
     */
    @JvmName("hwksirgyihneaueu")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SafetyRuleRuleConfigArgs = SafetyRuleRuleConfigArgs(
        inverted = inverted ?: throw PulumiNullFieldException("inverted"),
        threshold = threshold ?: throw PulumiNullFieldException("threshold"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
