@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoveryreadiness.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Cell].
 */
@PulumiTagMarker
public class CellResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CellArgs = CellArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CellArgsBuilder.() -> Unit) {
        val builder = CellArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Cell {
        val builtJavaResource = com.pulumi.aws.route53recoveryreadiness.Cell(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cell(builtJavaResource)
    }
}

/**
 * Provides an AWS Route 53 Recovery Readiness Cell.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53recoveryreadiness.Cell;
 * import com.pulumi.aws.route53recoveryreadiness.CellArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cell("example", CellArgs.builder()
 *             .cellName("us-west-2-failover-cell")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 Recovery Readiness cells using the cell name. For example:
 * ```sh
 *  $ pulumi import aws:route53recoveryreadiness/cell:Cell us-west-2-failover-cell us-west-2-failover-cell
 * ```
 *
 */
public class Cell internal constructor(
    override val javaResource: com.pulumi.aws.route53recoveryreadiness.Cell,
) : KotlinCustomResource(javaResource, CellMapper) {
    /**
     * ARN of the cell
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Unique name describing the cell.
     * The following arguments are optional:
     */
    public val cellName: Output<String>
        get() = javaResource.cellName().applyValue({ args0 -> args0 })

    /**
     * List of cell arns to add as nested fault domains within this cell.
     */
    public val cells: Output<List<String>>?
        get() = javaResource.cells().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * List of readiness scopes (recovery groups or cells) that contain this cell.
     */
    public val parentReadinessScopes: Output<List<String>>
        get() = javaResource.parentReadinessScopes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object CellMapper : ResourceMapper<Cell> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53recoveryreadiness.Cell::class == javaResource::class

    override fun map(javaResource: Resource): Cell = Cell(
        javaResource as
            com.pulumi.aws.route53recoveryreadiness.Cell,
    )
}

/**
 * @see [Cell].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cell].
 */
public suspend fun cell(name: String, block: suspend CellResourceBuilder.() -> Unit): Cell {
    val builder = CellResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cell].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cell(name: String): Cell {
    val builder = CellResourceBuilder()
    builder.name(name)
    return builder.build()
}
