@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoveryreadiness.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ReadinessCheck].
 */
@PulumiTagMarker
public class ReadinessCheckResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReadinessCheckArgs = ReadinessCheckArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReadinessCheckArgsBuilder.() -> Unit) {
        val builder = ReadinessCheckArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReadinessCheck {
        val builtJavaResource =
            com.pulumi.aws.route53recoveryreadiness.ReadinessCheck(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ReadinessCheck(builtJavaResource)
    }
}

/**
 * Provides an AWS Route 53 Recovery Readiness Readiness Check.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53recoveryreadiness.ReadinessCheck;
 * import com.pulumi.aws.route53recoveryreadiness.ReadinessCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ReadinessCheck("example", ReadinessCheckArgs.builder()
 *             .readinessCheckName(my_cw_alarm_check)
 *             .resourceSetName(my_cw_alarm_set)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 Recovery Readiness readiness checks using the readiness check name. For example:
 * ```sh
 *  $ pulumi import aws:route53recoveryreadiness/readinessCheck:ReadinessCheck my-cw-alarm-check example
 * ```
 *
 */
public class ReadinessCheck internal constructor(
    override val javaResource: com.pulumi.aws.route53recoveryreadiness.ReadinessCheck,
) : KotlinCustomResource(javaResource, ReadinessCheckMapper) {
    /**
     * ARN of the readiness_check
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Unique name describing the readiness check.
     */
    public val readinessCheckName: Output<String>
        get() = javaResource.readinessCheckName().applyValue({ args0 -> args0 })

    /**
     * Name describing the resource set that will be monitored for readiness.
     * The following arguments are optional:
     */
    public val resourceSetName: Output<String>
        get() = javaResource.resourceSetName().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ReadinessCheckMapper : ResourceMapper<ReadinessCheck> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53recoveryreadiness.ReadinessCheck::class == javaResource::class

    override fun map(javaResource: Resource): ReadinessCheck = ReadinessCheck(
        javaResource as
            com.pulumi.aws.route53recoveryreadiness.ReadinessCheck,
    )
}

/**
 * @see [ReadinessCheck].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReadinessCheck].
 */
public suspend fun readinessCheck(
    name: String,
    block: suspend ReadinessCheckResourceBuilder.() -> Unit,
): ReadinessCheck {
    val builder = ReadinessCheckResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReadinessCheck].
 * @param name The _unique_ name of the resulting resource.
 */
public fun readinessCheck(name: String): ReadinessCheck {
    val builder = ReadinessCheckResourceBuilder()
    builder.name(name)
    return builder.build()
}
