@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoveryreadiness.kotlin

import com.pulumi.aws.route53recoveryreadiness.ReadinessCheckArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Route 53 Recovery Readiness Readiness Check.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53recoveryreadiness.ReadinessCheck;
 * import com.pulumi.aws.route53recoveryreadiness.ReadinessCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ReadinessCheck("example", ReadinessCheckArgs.builder()
 *             .readinessCheckName(my_cw_alarm_check)
 *             .resourceSetName(my_cw_alarm_set)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 Recovery Readiness readiness checks using the readiness check name. For example:
 * ```sh
 *  $ pulumi import aws:route53recoveryreadiness/readinessCheck:ReadinessCheck my-cw-alarm-check example
 * ```
 * @property readinessCheckName Unique name describing the readiness check.
 * @property resourceSetName Name describing the resource set that will be monitored for readiness.
 * The following arguments are optional:
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
 */
public data class ReadinessCheckArgs(
    public val readinessCheckName: Output<String>? = null,
    public val resourceSetName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53recoveryreadiness.ReadinessCheckArgs> {
    override fun toJava(): com.pulumi.aws.route53recoveryreadiness.ReadinessCheckArgs =
        com.pulumi.aws.route53recoveryreadiness.ReadinessCheckArgs.builder()
            .readinessCheckName(readinessCheckName?.applyValue({ args0 -> args0 }))
            .resourceSetName(resourceSetName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ReadinessCheckArgs].
 */
@PulumiTagMarker
public class ReadinessCheckArgsBuilder internal constructor() {
    private var readinessCheckName: Output<String>? = null

    private var resourceSetName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Unique name describing the readiness check.
     */
    @JvmName("bgorfohjrffsojoa")
    public suspend fun readinessCheckName(`value`: Output<String>) {
        this.readinessCheckName = value
    }

    /**
     * @param value Name describing the resource set that will be monitored for readiness.
     * The following arguments are optional:
     */
    @JvmName("gepjtbyuxdxualkc")
    public suspend fun resourceSetName(`value`: Output<String>) {
        this.resourceSetName = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("absguoueouixmgqk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Unique name describing the readiness check.
     */
    @JvmName("genkquhdmtvpprmg")
    public suspend fun readinessCheckName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessCheckName = mapped
    }

    /**
     * @param value Name describing the resource set that will be monitored for readiness.
     * The following arguments are optional:
     */
    @JvmName("dddhasxucihymkby")
    public suspend fun resourceSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceSetName = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("qtjfhttugirvsxnw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("tmenitefagswpuhx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ReadinessCheckArgs = ReadinessCheckArgs(
        readinessCheckName = readinessCheckName,
        resourceSetName = resourceSetName,
        tags = tags,
    )
}
