@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoveryreadiness.kotlin

import com.pulumi.aws.route53recoveryreadiness.RecoveryGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Route 53 Recovery Readiness Recovery Group.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53recoveryreadiness.RecoveryGroup;
 * import com.pulumi.aws.route53recoveryreadiness.RecoveryGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RecoveryGroup("example", RecoveryGroupArgs.builder()
 *             .recoveryGroupName("my-high-availability-app")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 Recovery Readiness recovery groups using the recovery group name. For example:
 * ```sh
 *  $ pulumi import aws:route53recoveryreadiness/recoveryGroup:RecoveryGroup my-high-availability-app my-high-availability-app
 * ```
 * @property cells List of cell arns to add as nested fault domains within this recovery group
 * @property recoveryGroupName A unique name describing the recovery group.
 * The following argument are optional:
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
 */
public data class RecoveryGroupArgs(
    public val cells: Output<List<String>>? = null,
    public val recoveryGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53recoveryreadiness.RecoveryGroupArgs> {
    override fun toJava(): com.pulumi.aws.route53recoveryreadiness.RecoveryGroupArgs =
        com.pulumi.aws.route53recoveryreadiness.RecoveryGroupArgs.builder()
            .cells(cells?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .recoveryGroupName(recoveryGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RecoveryGroupArgs].
 */
@PulumiTagMarker
public class RecoveryGroupArgsBuilder internal constructor() {
    private var cells: Output<List<String>>? = null

    private var recoveryGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value List of cell arns to add as nested fault domains within this recovery group
     */
    @JvmName("rugcbksqnvmrrmll")
    public suspend fun cells(`value`: Output<List<String>>) {
        this.cells = value
    }

    @JvmName("uovvvpghrgtawtnm")
    public suspend fun cells(vararg values: Output<String>) {
        this.cells = Output.all(values.asList())
    }

    /**
     * @param values List of cell arns to add as nested fault domains within this recovery group
     */
    @JvmName("kxdvbydqlhvsribl")
    public suspend fun cells(values: List<Output<String>>) {
        this.cells = Output.all(values)
    }

    /**
     * @param value A unique name describing the recovery group.
     * The following argument are optional:
     */
    @JvmName("ourxrbdmcehqgbtx")
    public suspend fun recoveryGroupName(`value`: Output<String>) {
        this.recoveryGroupName = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("uwfkimsdgrucwtvn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of cell arns to add as nested fault domains within this recovery group
     */
    @JvmName("bqpdhfylovwufyqe")
    public suspend fun cells(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cells = mapped
    }

    /**
     * @param values List of cell arns to add as nested fault domains within this recovery group
     */
    @JvmName("vsbvtcdkpekwtfyd")
    public suspend fun cells(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cells = mapped
    }

    /**
     * @param value A unique name describing the recovery group.
     * The following argument are optional:
     */
    @JvmName("eqnrfejhyootrxvi")
    public suspend fun recoveryGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryGroupName = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("trilqqqbomldgehh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("nrhjqcrdkalbdmqw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RecoveryGroupArgs = RecoveryGroupArgs(
        cells = cells,
        recoveryGroupName = recoveryGroupName,
        tags = tags,
    )
}
