@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoveryreadiness.kotlin.inputs

import com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property componentId
 * @property dnsTargetResource Component for DNS/Routing Control Readiness Checks.
 * @property readinessScopes Recovery group ARN or cell ARN that contains this resource set.
 * @property resourceArn ARN of the resource.
 */
public data class ResourceSetResourceArgs(
    public val componentId: Output<String>? = null,
    public val dnsTargetResource: Output<ResourceSetResourceDnsTargetResourceArgs>? = null,
    public val readinessScopes: Output<List<String>>? = null,
    public val resourceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceArgs> {
    override fun toJava(): com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceArgs =
        com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceArgs.builder()
            .componentId(componentId?.applyValue({ args0 -> args0 }))
            .dnsTargetResource(dnsTargetResource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .readinessScopes(readinessScopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceSetResourceArgs].
 */
@PulumiTagMarker
public class ResourceSetResourceArgsBuilder internal constructor() {
    private var componentId: Output<String>? = null

    private var dnsTargetResource: Output<ResourceSetResourceDnsTargetResourceArgs>? = null

    private var readinessScopes: Output<List<String>>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("xomoestppkgrnhil")
    public suspend fun componentId(`value`: Output<String>) {
        this.componentId = value
    }

    /**
     * @param value Component for DNS/Routing Control Readiness Checks.
     */
    @JvmName("jsppvjnrbgvkradd")
    public suspend fun dnsTargetResource(`value`: Output<ResourceSetResourceDnsTargetResourceArgs>) {
        this.dnsTargetResource = value
    }

    /**
     * @param value Recovery group ARN or cell ARN that contains this resource set.
     */
    @JvmName("mgpxcpwjdnfchpnm")
    public suspend fun readinessScopes(`value`: Output<List<String>>) {
        this.readinessScopes = value
    }

    @JvmName("fkdumoambfgxysha")
    public suspend fun readinessScopes(vararg values: Output<String>) {
        this.readinessScopes = Output.all(values.asList())
    }

    /**
     * @param values Recovery group ARN or cell ARN that contains this resource set.
     */
    @JvmName("oxwqcaxxbixrkcgm")
    public suspend fun readinessScopes(values: List<Output<String>>) {
        this.readinessScopes = Output.all(values)
    }

    /**
     * @param value ARN of the resource.
     */
    @JvmName("llpmertmqnpqqcdn")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value
     */
    @JvmName("gmiroxxyswvkwlti")
    public suspend fun componentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentId = mapped
    }

    /**
     * @param value Component for DNS/Routing Control Readiness Checks.
     */
    @JvmName("cngnobfpojqcgwwa")
    public suspend fun dnsTargetResource(`value`: ResourceSetResourceDnsTargetResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsTargetResource = mapped
    }

    /**
     * @param argument Component for DNS/Routing Control Readiness Checks.
     */
    @JvmName("ggsukaaxtgprkbxj")
    public suspend
    fun dnsTargetResource(argument: suspend ResourceSetResourceDnsTargetResourceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSetResourceDnsTargetResourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dnsTargetResource = mapped
    }

    /**
     * @param value Recovery group ARN or cell ARN that contains this resource set.
     */
    @JvmName("upidiwxqrrrkpypn")
    public suspend fun readinessScopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessScopes = mapped
    }

    /**
     * @param values Recovery group ARN or cell ARN that contains this resource set.
     */
    @JvmName("vmpsjtdhaxqjeyeu")
    public suspend fun readinessScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.readinessScopes = mapped
    }

    /**
     * @param value ARN of the resource.
     */
    @JvmName("amuxrwhotncvslux")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): ResourceSetResourceArgs = ResourceSetResourceArgs(
        componentId = componentId,
        dnsTargetResource = dnsTargetResource,
        readinessScopes = readinessScopes,
        resourceArn = resourceArn,
    )
}
