@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoveryreadiness.kotlin.inputs

import com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceTargetResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property nlbResource NLB resource a DNS Target Resource points to. Required if `r53_resource` is not set.
 * @property r53Resource Route53 resource a DNS Target Resource record points to.
 */
public data class ResourceSetResourceDnsTargetResourceTargetResourceArgs(
    public val nlbResource: Output<ResourceSetResourceDnsTargetResourceTargetResourceNlbResourceArgs>? =
        null,
    public val r53Resource: Output<ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceTargetResourceArgs> {
    override fun toJava():
        com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceTargetResourceArgs =
        com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceTargetResourceArgs.builder()
            .nlbResource(nlbResource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .r53Resource(r53Resource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ResourceSetResourceDnsTargetResourceTargetResourceArgs].
 */
@PulumiTagMarker
public class ResourceSetResourceDnsTargetResourceTargetResourceArgsBuilder internal constructor() {
    private var nlbResource:
        Output<ResourceSetResourceDnsTargetResourceTargetResourceNlbResourceArgs>? = null

    private var r53Resource:
        Output<ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs>? = null

    /**
     * @param value NLB resource a DNS Target Resource points to. Required if `r53_resource` is not set.
     */
    @JvmName("ydkaucxqpqvtemoo")
    public suspend
    fun nlbResource(`value`: Output<ResourceSetResourceDnsTargetResourceTargetResourceNlbResourceArgs>) {
        this.nlbResource = value
    }

    /**
     * @param value Route53 resource a DNS Target Resource record points to.
     */
    @JvmName("mbkobikppbldenuk")
    public suspend
    fun r53Resource(`value`: Output<ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs>) {
        this.r53Resource = value
    }

    /**
     * @param value NLB resource a DNS Target Resource points to. Required if `r53_resource` is not set.
     */
    @JvmName("prpntbkspofplvmw")
    public suspend
    fun nlbResource(`value`: ResourceSetResourceDnsTargetResourceTargetResourceNlbResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nlbResource = mapped
    }

    /**
     * @param argument NLB resource a DNS Target Resource points to. Required if `r53_resource` is not set.
     */
    @JvmName("aivpdihutdnlaqfv")
    public suspend
    fun nlbResource(argument: suspend ResourceSetResourceDnsTargetResourceTargetResourceNlbResourceArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResourceSetResourceDnsTargetResourceTargetResourceNlbResourceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.nlbResource = mapped
    }

    /**
     * @param value Route53 resource a DNS Target Resource record points to.
     */
    @JvmName("ohiekrlxdmyodasi")
    public suspend
    fun r53Resource(`value`: ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.r53Resource = mapped
    }

    /**
     * @param argument Route53 resource a DNS Target Resource record points to.
     */
    @JvmName("guwdaqsbrwpjfvbd")
    public suspend
    fun r53Resource(argument: suspend ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.r53Resource = mapped
    }

    internal fun build(): ResourceSetResourceDnsTargetResourceTargetResourceArgs =
        ResourceSetResourceDnsTargetResourceTargetResourceArgs(
            nlbResource = nlbResource,
            r53Resource = r53Resource,
        )
}
