@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoveryreadiness.kotlin.inputs

import com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceTargetResourceNlbResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn NLB resource ARN.
 */
public data class ResourceSetResourceDnsTargetResourceTargetResourceNlbResourceArgs(
    public val arn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceTargetResourceNlbResourceArgs> {
    override fun toJava():
        com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceTargetResourceNlbResourceArgs =
        com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceTargetResourceNlbResourceArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceSetResourceDnsTargetResourceTargetResourceNlbResourceArgs].
 */
@PulumiTagMarker
public class ResourceSetResourceDnsTargetResourceTargetResourceNlbResourceArgsBuilder internal
constructor() {
    private var arn: Output<String>? = null

    /**
     * @param value NLB resource ARN.
     */
    @JvmName("avyptosgrssudltr")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value NLB resource ARN.
     */
    @JvmName("chmjyefcoabqjyxh")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    internal fun build(): ResourceSetResourceDnsTargetResourceTargetResourceNlbResourceArgs =
        ResourceSetResourceDnsTargetResourceTargetResourceNlbResourceArgs(
            arn = arn,
        )
}
