@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoveryreadiness.kotlin.inputs

import com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainName DNS Name that acts as the ingress point to a portion of application.
 * @property recordSetId Route53 record set id to uniquely identify a record given a `domain_name` and a `record_type`.
 */
public data class ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs(
    public val domainName: Output<String>? = null,
    public val recordSetId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs> {
    override fun toJava():
        com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs =
        com.pulumi.aws.route53recoveryreadiness.inputs.ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .recordSetId(recordSetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs].
 */
@PulumiTagMarker
public class ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgsBuilder internal
constructor() {
    private var domainName: Output<String>? = null

    private var recordSetId: Output<String>? = null

    /**
     * @param value DNS Name that acts as the ingress point to a portion of application.
     */
    @JvmName("bbuicqdnswcdicfa")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Route53 record set id to uniquely identify a record given a `domain_name` and a `record_type`.
     */
    @JvmName("uqlvlejboppqaaci")
    public suspend fun recordSetId(`value`: Output<String>) {
        this.recordSetId = value
    }

    /**
     * @param value DNS Name that acts as the ingress point to a portion of application.
     */
    @JvmName("lwvwglybdicaqxtr")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Route53 record set id to uniquely identify a record given a `domain_name` and a `record_type`.
     */
    @JvmName("mqvqgfurighylisu")
    public suspend fun recordSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordSetId = mapped
    }

    internal fun build(): ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs =
        ResourceSetResourceDnsTargetResourceTargetResourceR53ResourceArgs(
            domainName = domainName,
            recordSetId = recordSetId,
        )
}
