@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoveryreadiness.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property domainName DNS Name that acts as the ingress point to a portion of application.
 * @property hostedZoneArn Hosted Zone ARN that contains the DNS record with the provided name of target resource.
 * @property recordSetId Route53 record set id to uniquely identify a record given a `domain_name` and a `record_type`.
 * @property recordType Type of DNS Record of target resource.
 * @property targetResource Target resource the R53 record specified with the above params points to.
 */
public data class ResourceSetResourceDnsTargetResource(
    public val domainName: String,
    public val hostedZoneArn: String? = null,
    public val recordSetId: String? = null,
    public val recordType: String? = null,
    public val targetResource: ResourceSetResourceDnsTargetResourceTargetResource? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.route53recoveryreadiness.outputs.ResourceSetResourceDnsTargetResource):
            ResourceSetResourceDnsTargetResource = ResourceSetResourceDnsTargetResource(
            domainName = javaType.domainName(),
            hostedZoneArn = javaType.hostedZoneArn().map({ args0 -> args0 }).orElse(null),
            recordSetId = javaType.recordSetId().map({ args0 -> args0 }).orElse(null),
            recordType = javaType.recordType().map({ args0 -> args0 }).orElse(null),
            targetResource = javaType.targetResource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.route53recoveryreadiness.kotlin.outputs.ResourceSetResourceDnsTargetResourceTargetResource.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
