@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53recoveryreadiness.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property nlbResource NLB resource a DNS Target Resource points to. Required if `r53_resource` is not set.
 * @property r53Resource Route53 resource a DNS Target Resource record points to.
 */
public data class ResourceSetResourceDnsTargetResourceTargetResource(
    public val nlbResource: ResourceSetResourceDnsTargetResourceTargetResourceNlbResource? = null,
    public val r53Resource: ResourceSetResourceDnsTargetResourceTargetResourceR53Resource? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.route53recoveryreadiness.outputs.ResourceSetResourceDnsTargetResourceTargetResource):
            ResourceSetResourceDnsTargetResourceTargetResource =
            ResourceSetResourceDnsTargetResourceTargetResource(
                nlbResource = javaType.nlbResource().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.route53recoveryreadiness.kotlin.outputs.ResourceSetResourceDnsTargetResourceTargetResourceNlbResource.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                r53Resource = javaType.r53Resource().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.route53recoveryreadiness.kotlin.outputs.ResourceSetResourceDnsTargetResourceTargetResourceR53Resource.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
