@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rum.kotlin

import com.pulumi.aws.rum.AppMonitorArgs.builder
import com.pulumi.aws.rum.kotlin.inputs.AppMonitorAppMonitorConfigurationArgs
import com.pulumi.aws.rum.kotlin.inputs.AppMonitorAppMonitorConfigurationArgsBuilder
import com.pulumi.aws.rum.kotlin.inputs.AppMonitorCustomEventsArgs
import com.pulumi.aws.rum.kotlin.inputs.AppMonitorCustomEventsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch RUM App Monitor resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rum.AppMonitor;
 * import com.pulumi.aws.rum.AppMonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AppMonitor("example", AppMonitorArgs.builder()
 *             .domain("localhost")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cloudwatch RUM App Monitor using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:rum/appMonitor:AppMonitor example example
 * ```
 * @property appMonitorConfiguration configuration data for the app monitor. See app_monitor_configuration below.
 * @property customEvents Specifies whether this app monitor allows the web client to define and send custom events. If you omit this parameter, custom events are `DISABLED`. See custom_events below.
 * @property cwLogEnabled Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter  specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges. Default value is `false`.
 * @property domain The top-level internet domain name for which your application has administrative authority.
 * @property name The name of the log stream.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AppMonitorArgs(
    public val appMonitorConfiguration: Output<AppMonitorAppMonitorConfigurationArgs>? = null,
    public val customEvents: Output<AppMonitorCustomEventsArgs>? = null,
    public val cwLogEnabled: Output<Boolean>? = null,
    public val domain: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rum.AppMonitorArgs> {
    override fun toJava(): com.pulumi.aws.rum.AppMonitorArgs =
        com.pulumi.aws.rum.AppMonitorArgs.builder()
            .appMonitorConfiguration(
                appMonitorConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customEvents(customEvents?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cwLogEnabled(cwLogEnabled?.applyValue({ args0 -> args0 }))
            .domain(domain?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AppMonitorArgs].
 */
@PulumiTagMarker
public class AppMonitorArgsBuilder internal constructor() {
    private var appMonitorConfiguration: Output<AppMonitorAppMonitorConfigurationArgs>? = null

    private var customEvents: Output<AppMonitorCustomEventsArgs>? = null

    private var cwLogEnabled: Output<Boolean>? = null

    private var domain: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value configuration data for the app monitor. See app_monitor_configuration below.
     */
    @JvmName("vvwruhkqnsjtxevm")
    public suspend
    fun appMonitorConfiguration(`value`: Output<AppMonitorAppMonitorConfigurationArgs>) {
        this.appMonitorConfiguration = value
    }

    /**
     * @param value Specifies whether this app monitor allows the web client to define and send custom events. If you omit this parameter, custom events are `DISABLED`. See custom_events below.
     */
    @JvmName("vefhervjyayyvxpu")
    public suspend fun customEvents(`value`: Output<AppMonitorCustomEventsArgs>) {
        this.customEvents = value
    }

    /**
     * @param value Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter  specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges. Default value is `false`.
     */
    @JvmName("ktykscxnqajkyuxm")
    public suspend fun cwLogEnabled(`value`: Output<Boolean>) {
        this.cwLogEnabled = value
    }

    /**
     * @param value The top-level internet domain name for which your application has administrative authority.
     */
    @JvmName("jltdyoswsvclgdsv")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The name of the log stream.
     */
    @JvmName("icrlnvoxuednpwsi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("acqapqevpksglvsi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value configuration data for the app monitor. See app_monitor_configuration below.
     */
    @JvmName("smkybmpjgntxuviu")
    public suspend fun appMonitorConfiguration(`value`: AppMonitorAppMonitorConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appMonitorConfiguration = mapped
    }

    /**
     * @param argument configuration data for the app monitor. See app_monitor_configuration below.
     */
    @JvmName("kiusijlsjniobkvd")
    public suspend
    fun appMonitorConfiguration(argument: suspend AppMonitorAppMonitorConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AppMonitorAppMonitorConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.appMonitorConfiguration = mapped
    }

    /**
     * @param value Specifies whether this app monitor allows the web client to define and send custom events. If you omit this parameter, custom events are `DISABLED`. See custom_events below.
     */
    @JvmName("crqsadhwnvccqmrx")
    public suspend fun customEvents(`value`: AppMonitorCustomEventsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customEvents = mapped
    }

    /**
     * @param argument Specifies whether this app monitor allows the web client to define and send custom events. If you omit this parameter, custom events are `DISABLED`. See custom_events below.
     */
    @JvmName("vbkbeqncteygojrx")
    public suspend fun customEvents(argument: suspend AppMonitorCustomEventsArgsBuilder.() -> Unit) {
        val toBeMapped = AppMonitorCustomEventsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customEvents = mapped
    }

    /**
     * @param value Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter  specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges. Default value is `false`.
     */
    @JvmName("fjcoexbuhrxhmmro")
    public suspend fun cwLogEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cwLogEnabled = mapped
    }

    /**
     * @param value The top-level internet domain name for which your application has administrative authority.
     */
    @JvmName("mxhxnfmlmuyyeywf")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The name of the log stream.
     */
    @JvmName("vfhbruviygkrsfat")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xajlvstfmmdprmtk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wasvbtfvwqiirofq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AppMonitorArgs = AppMonitorArgs(
        appMonitorConfiguration = appMonitorConfiguration,
        customEvents = customEvents,
        cwLogEnabled = cwLogEnabled,
        domain = domain,
        name = name,
        tags = tags,
    )
}
