@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rum.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MetricsDestination].
 */
@PulumiTagMarker
public class MetricsDestinationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MetricsDestinationArgs = MetricsDestinationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MetricsDestinationArgsBuilder.() -> Unit) {
        val builder = MetricsDestinationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MetricsDestination {
        val builtJavaResource = com.pulumi.aws.rum.MetricsDestination(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MetricsDestination(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch RUM Metrics Destination resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rum.MetricsDestination;
 * import com.pulumi.aws.rum.MetricsDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MetricsDestination("example", MetricsDestinationArgs.builder()
 *             .appMonitorName(aws_rum_app_monitor.example().name())
 *             .destination("CloudWatch")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cloudwatch RUM Metrics Destination using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:rum/metricsDestination:MetricsDestination example example
 * ```
 *
 */
public class MetricsDestination internal constructor(
    override val javaResource: com.pulumi.aws.rum.MetricsDestination,
) : KotlinCustomResource(javaResource, MetricsDestinationMapper) {
    /**
     * The name of the CloudWatch RUM app monitor that will send the metrics.
     */
    public val appMonitorName: Output<String>
        get() = javaResource.appMonitorName().applyValue({ args0 -> args0 })

    /**
     * Defines the destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
     */
    public val destination: Output<String>
        get() = javaResource.destination().applyValue({ args0 -> args0 })

    /**
     * Use this parameter only if Destination is Evidently. This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
     */
    public val destinationArn: Output<String>?
        get() = javaResource.destinationArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This parameter is required if Destination is Evidently. If Destination is CloudWatch, do not use this parameter.
     */
    public val iamRoleArn: Output<String>?
        get() = javaResource.iamRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object MetricsDestinationMapper : ResourceMapper<MetricsDestination> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rum.MetricsDestination::class == javaResource::class

    override fun map(javaResource: Resource): MetricsDestination = MetricsDestination(
        javaResource as
            com.pulumi.aws.rum.MetricsDestination,
    )
}

/**
 * @see [MetricsDestination].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MetricsDestination].
 */
public suspend fun metricsDestination(
    name: String,
    block: suspend MetricsDestinationResourceBuilder.() -> Unit,
): MetricsDestination {
    val builder = MetricsDestinationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MetricsDestination].
 * @param name The _unique_ name of the resulting resource.
 */
public fun metricsDestination(name: String): MetricsDestination {
    val builder = MetricsDestinationResourceBuilder()
    builder.name(name)
    return builder.build()
}
