@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.AccessPointArgs.builder
import com.pulumi.aws.s3.kotlin.inputs.AccessPointPublicAccessBlockConfigurationArgs
import com.pulumi.aws.s3.kotlin.inputs.AccessPointPublicAccessBlockConfigurationArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.AccessPointVpcConfigurationArgs
import com.pulumi.aws.s3.kotlin.inputs.AccessPointVpcConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an S3 Access Point.
 * > **NOTE on Access Points and Access Point Policies:** This provider provides both a standalone Access Point Policy resource and an Access Point resource with a resource policy defined in-line. You cannot use an Access Point with in-line resource policy in conjunction with an Access Point Policy resource. Doing so will cause a conflict of policies and will overwrite the access point's resource policy.
 * > Advanced usage: To use a custom API endpoint for this resource, use the `s3control` endpoint provider configuration), not the `s3` endpoint provider configuration.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### AWS Partition General Purpose Bucket
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.AccessPoint;
 * import com.pulumi.aws.s3.AccessPointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleAccessPoint = new AccessPoint("exampleAccessPoint", AccessPointArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .build());
 *     }
 * }
 * ```
 * ### S3 on Outposts Bucket
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3control.Bucket;
 * import com.pulumi.aws.s3control.BucketArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.s3.AccessPoint;
 * import com.pulumi.aws.s3.AccessPointArgs;
 * import com.pulumi.aws.s3.inputs.AccessPointVpcConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucket = new Bucket("exampleBucket", BucketArgs.builder()
 *             .bucket("example")
 *             .build());
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var exampleAccessPoint = new AccessPoint("exampleAccessPoint", AccessPointArgs.builder()
 *             .bucket(exampleBucket.arn())
 *             .vpcConfiguration(AccessPointVpcConfigurationArgs.builder()
 *                 .vpcId(exampleVpc.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Import using the ARN for Access Points associated with an S3 on Outposts Bucket:
 * __Using `pulumi import` to import.__ For example:
 * Import using the `account_id` and `name` separated by a colon (`:`) for Access Points associated with an AWS Partition S3 Bucket:
 * ```sh
 *  $ pulumi import aws:s3/accessPoint:AccessPoint example 123456789012:example
 * ```
 *  Import using the ARN for Access Points associated with an S3 on Outposts Bucket:
 * ```sh
 *  $ pulumi import aws:s3/accessPoint:AccessPoint example arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-1234567890123456/accesspoint/example
 * ```
 * @property accountId AWS account ID for the owner of the bucket for which you want to create an access point. Defaults to automatically determined account ID of the AWS provider.
 * @property bucket Name of an AWS Partition S3 General Purpose Bucket or the ARN of S3 on Outposts Bucket that you want to associate this access point with.
 * @property bucketAccountId AWS account ID associated with the S3 bucket associated with this access point.
 * @property name Name you want to assign to this access point.
 * The following arguments are optional:
 * @property policy Valid JSON document that specifies the policy that you want to apply to this access point. Removing `policy` from your configuration or setting `policy` to null or an empty string (i.e., `policy = ""`) _will not_ delete the policy since it could have been set by `aws.s3control.AccessPointPolicy`. To remove the `policy`, set it to `"{}"` (an empty JSON document).
 * @property publicAccessBlockConfiguration Configuration block to manage the `PublicAccessBlock` configuration that you want to apply to this Amazon S3 bucket. You can enable the configuration options in any combination. Detailed below.
 * @property vpcConfiguration Configuration block to restrict access to this access point to requests from the specified Virtual Private Cloud (VPC). Required for S3 on Outposts. Detailed below.
 */
public data class AccessPointArgs(
    public val accountId: Output<String>? = null,
    public val bucket: Output<String>? = null,
    public val bucketAccountId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val publicAccessBlockConfiguration: Output<AccessPointPublicAccessBlockConfigurationArgs>? =
        null,
    public val vpcConfiguration: Output<AccessPointVpcConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.AccessPointArgs> {
    override fun toJava(): com.pulumi.aws.s3.AccessPointArgs =
        com.pulumi.aws.s3.AccessPointArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .bucketAccountId(bucketAccountId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .publicAccessBlockConfiguration(
                publicAccessBlockConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .vpcConfiguration(
                vpcConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AccessPointArgs].
 */
@PulumiTagMarker
public class AccessPointArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var bucket: Output<String>? = null

    private var bucketAccountId: Output<String>? = null

    private var name: Output<String>? = null

    private var policy: Output<String>? = null

    private var publicAccessBlockConfiguration: Output<AccessPointPublicAccessBlockConfigurationArgs>? =
        null

    private var vpcConfiguration: Output<AccessPointVpcConfigurationArgs>? = null

    /**
     * @param value AWS account ID for the owner of the bucket for which you want to create an access point. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("pxvuqgalqcdaglbt")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value Name of an AWS Partition S3 General Purpose Bucket or the ARN of S3 on Outposts Bucket that you want to associate this access point with.
     */
    @JvmName("jkiwnjurffsaawfi")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value AWS account ID associated with the S3 bucket associated with this access point.
     */
    @JvmName("ivfqpmwpciqapuoi")
    public suspend fun bucketAccountId(`value`: Output<String>) {
        this.bucketAccountId = value
    }

    /**
     * @param value Name you want to assign to this access point.
     * The following arguments are optional:
     */
    @JvmName("ocvfiqjiibacpbpm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Valid JSON document that specifies the policy that you want to apply to this access point. Removing `policy` from your configuration or setting `policy` to null or an empty string (i.e., `policy = ""`) _will not_ delete the policy since it could have been set by `aws.s3control.AccessPointPolicy`. To remove the `policy`, set it to `"{}"` (an empty JSON document).
     */
    @JvmName("txbgjjcgitrmovuf")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Configuration block to manage the `PublicAccessBlock` configuration that you want to apply to this Amazon S3 bucket. You can enable the configuration options in any combination. Detailed below.
     */
    @JvmName("mgjqbxlgvcvigmuj")
    public suspend
    fun publicAccessBlockConfiguration(`value`: Output<AccessPointPublicAccessBlockConfigurationArgs>) {
        this.publicAccessBlockConfiguration = value
    }

    /**
     * @param value Configuration block to restrict access to this access point to requests from the specified Virtual Private Cloud (VPC). Required for S3 on Outposts. Detailed below.
     */
    @JvmName("bpplbrbmltvchrib")
    public suspend fun vpcConfiguration(`value`: Output<AccessPointVpcConfigurationArgs>) {
        this.vpcConfiguration = value
    }

    /**
     * @param value AWS account ID for the owner of the bucket for which you want to create an access point. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("caljoqqmwuiiubbs")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value Name of an AWS Partition S3 General Purpose Bucket or the ARN of S3 on Outposts Bucket that you want to associate this access point with.
     */
    @JvmName("touncacdxfqrhjrn")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value AWS account ID associated with the S3 bucket associated with this access point.
     */
    @JvmName("qeaomgrqhsorlrjo")
    public suspend fun bucketAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketAccountId = mapped
    }

    /**
     * @param value Name you want to assign to this access point.
     * The following arguments are optional:
     */
    @JvmName("fywnsgnaqenpfuah")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Valid JSON document that specifies the policy that you want to apply to this access point. Removing `policy` from your configuration or setting `policy` to null or an empty string (i.e., `policy = ""`) _will not_ delete the policy since it could have been set by `aws.s3control.AccessPointPolicy`. To remove the `policy`, set it to `"{}"` (an empty JSON document).
     */
    @JvmName("akjhipgcyqovbxhw")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value Configuration block to manage the `PublicAccessBlock` configuration that you want to apply to this Amazon S3 bucket. You can enable the configuration options in any combination. Detailed below.
     */
    @JvmName("ffrhcfkctruremnx")
    public suspend
    fun publicAccessBlockConfiguration(`value`: AccessPointPublicAccessBlockConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicAccessBlockConfiguration = mapped
    }

    /**
     * @param argument Configuration block to manage the `PublicAccessBlock` configuration that you want to apply to this Amazon S3 bucket. You can enable the configuration options in any combination. Detailed below.
     */
    @JvmName("ugbailwytsflsrie")
    public suspend
    fun publicAccessBlockConfiguration(argument: suspend AccessPointPublicAccessBlockConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AccessPointPublicAccessBlockConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.publicAccessBlockConfiguration = mapped
    }

    /**
     * @param value Configuration block to restrict access to this access point to requests from the specified Virtual Private Cloud (VPC). Required for S3 on Outposts. Detailed below.
     */
    @JvmName("uyypakgavybrhbdu")
    public suspend fun vpcConfiguration(`value`: AccessPointVpcConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfiguration = mapped
    }

    /**
     * @param argument Configuration block to restrict access to this access point to requests from the specified Virtual Private Cloud (VPC). Required for S3 on Outposts. Detailed below.
     */
    @JvmName("vsysvfwyfogqlyuu")
    public suspend
    fun vpcConfiguration(argument: suspend AccessPointVpcConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AccessPointVpcConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfiguration = mapped
    }

    internal fun build(): AccessPointArgs = AccessPointArgs(
        accountId = accountId,
        bucket = bucket,
        bucketAccountId = bucketAccountId,
        name = name,
        policy = policy,
        publicAccessBlockConfiguration = publicAccessBlockConfiguration,
        vpcConfiguration = vpcConfiguration,
    )
}
