@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.AccountPublicAccessBlockArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages S3 account-level Public Access Block configuration. For more information about these settings, see the [AWS S3 Block Public Access documentation](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html).
 * > **NOTE:** Each AWS account may only have one S3 Public Access Block configuration. Multiple configurations of the resource against the same AWS account will cause a perpetual difference.
 * > Advanced usage: To use a custom API endpoint for this resource, use the `s3control` endpoint provider configuration, not the `s3` endpoint provider configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.AccountPublicAccessBlock;
 * import com.pulumi.aws.s3.AccountPublicAccessBlockArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccountPublicAccessBlock("example", AccountPublicAccessBlockArgs.builder()
 *             .blockPublicAcls(true)
 *             .blockPublicPolicy(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_s3_account_public_access_block` using the AWS account ID. For example:
 * ```sh
 *  $ pulumi import aws:s3/accountPublicAccessBlock:AccountPublicAccessBlock example 123456789012
 * ```
 * @property accountId AWS account ID to configure. Defaults to automatically determined account ID of the this provider AWS provider.
 * @property blockPublicAcls Whether Amazon S3 should block public ACLs for buckets in this account. Defaults to `false`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
 * * PUT Bucket acl and PUT Object acl calls will fail if the specified ACL allows public access.
 * * PUT Object calls fail if the request includes a public ACL.
 * @property blockPublicPolicy Whether Amazon S3 should block public bucket policies for buckets in this account. Defaults to `false`. Enabling this setting does not affect existing bucket policies. When set to `true` causes Amazon S3 to:
 * * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
 * @property ignorePublicAcls Whether Amazon S3 should ignore public ACLs for buckets in this account. Defaults to `false`. Enabling this setting does not affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
 * * Ignore all public ACLs on buckets in this account and any objects that they contain.
 * @property restrictPublicBuckets Whether Amazon S3 should restrict public bucket policies for buckets in this account. Defaults to `false`. Enabling this setting does not affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
 * * Only the bucket owner and AWS Services can access buckets with public policies.
 */
public data class AccountPublicAccessBlockArgs(
    public val accountId: Output<String>? = null,
    public val blockPublicAcls: Output<Boolean>? = null,
    public val blockPublicPolicy: Output<Boolean>? = null,
    public val ignorePublicAcls: Output<Boolean>? = null,
    public val restrictPublicBuckets: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.AccountPublicAccessBlockArgs> {
    override fun toJava(): com.pulumi.aws.s3.AccountPublicAccessBlockArgs =
        com.pulumi.aws.s3.AccountPublicAccessBlockArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .blockPublicAcls(blockPublicAcls?.applyValue({ args0 -> args0 }))
            .blockPublicPolicy(blockPublicPolicy?.applyValue({ args0 -> args0 }))
            .ignorePublicAcls(ignorePublicAcls?.applyValue({ args0 -> args0 }))
            .restrictPublicBuckets(restrictPublicBuckets?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountPublicAccessBlockArgs].
 */
@PulumiTagMarker
public class AccountPublicAccessBlockArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var blockPublicAcls: Output<Boolean>? = null

    private var blockPublicPolicy: Output<Boolean>? = null

    private var ignorePublicAcls: Output<Boolean>? = null

    private var restrictPublicBuckets: Output<Boolean>? = null

    /**
     * @param value AWS account ID to configure. Defaults to automatically determined account ID of the this provider AWS provider.
     */
    @JvmName("kvgnjugenedyosal")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value Whether Amazon S3 should block public ACLs for buckets in this account. Defaults to `false`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
     * * PUT Bucket acl and PUT Object acl calls will fail if the specified ACL allows public access.
     * * PUT Object calls fail if the request includes a public ACL.
     */
    @JvmName("jcricxhgxyviloks")
    public suspend fun blockPublicAcls(`value`: Output<Boolean>) {
        this.blockPublicAcls = value
    }

    /**
     * @param value Whether Amazon S3 should block public bucket policies for buckets in this account. Defaults to `false`. Enabling this setting does not affect existing bucket policies. When set to `true` causes Amazon S3 to:
     * * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
     */
    @JvmName("jsslfhjjemwoiuip")
    public suspend fun blockPublicPolicy(`value`: Output<Boolean>) {
        this.blockPublicPolicy = value
    }

    /**
     * @param value Whether Amazon S3 should ignore public ACLs for buckets in this account. Defaults to `false`. Enabling this setting does not affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
     * * Ignore all public ACLs on buckets in this account and any objects that they contain.
     */
    @JvmName("vklrecxahlcuagbk")
    public suspend fun ignorePublicAcls(`value`: Output<Boolean>) {
        this.ignorePublicAcls = value
    }

    /**
     * @param value Whether Amazon S3 should restrict public bucket policies for buckets in this account. Defaults to `false`. Enabling this setting does not affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
     * * Only the bucket owner and AWS Services can access buckets with public policies.
     */
    @JvmName("lpxteloniqodaorq")
    public suspend fun restrictPublicBuckets(`value`: Output<Boolean>) {
        this.restrictPublicBuckets = value
    }

    /**
     * @param value AWS account ID to configure. Defaults to automatically determined account ID of the this provider AWS provider.
     */
    @JvmName("uihmtdqgcsdgdjwn")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value Whether Amazon S3 should block public ACLs for buckets in this account. Defaults to `false`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
     * * PUT Bucket acl and PUT Object acl calls will fail if the specified ACL allows public access.
     * * PUT Object calls fail if the request includes a public ACL.
     */
    @JvmName("gkffcetdeqptsmgv")
    public suspend fun blockPublicAcls(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockPublicAcls = mapped
    }

    /**
     * @param value Whether Amazon S3 should block public bucket policies for buckets in this account. Defaults to `false`. Enabling this setting does not affect existing bucket policies. When set to `true` causes Amazon S3 to:
     * * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
     */
    @JvmName("uhoqycmcolxcssvt")
    public suspend fun blockPublicPolicy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockPublicPolicy = mapped
    }

    /**
     * @param value Whether Amazon S3 should ignore public ACLs for buckets in this account. Defaults to `false`. Enabling this setting does not affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
     * * Ignore all public ACLs on buckets in this account and any objects that they contain.
     */
    @JvmName("dmhyiyrrcopivwmp")
    public suspend fun ignorePublicAcls(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignorePublicAcls = mapped
    }

    /**
     * @param value Whether Amazon S3 should restrict public bucket policies for buckets in this account. Defaults to `false`. Enabling this setting does not affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
     * * Only the bucket owner and AWS Services can access buckets with public policies.
     */
    @JvmName("xpxwynbulxkgyqwc")
    public suspend fun restrictPublicBuckets(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restrictPublicBuckets = mapped
    }

    internal fun build(): AccountPublicAccessBlockArgs = AccountPublicAccessBlockArgs(
        accountId = accountId,
        blockPublicAcls = blockPublicAcls,
        blockPublicPolicy = blockPublicPolicy,
        ignorePublicAcls = ignorePublicAcls,
        restrictPublicBuckets = restrictPublicBuckets,
    )
}
