@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.AnalyticsConfigurationFilter
import com.pulumi.aws.s3.kotlin.outputs.AnalyticsConfigurationStorageClassAnalysis
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.s3.kotlin.outputs.AnalyticsConfigurationFilter.Companion.toKotlin as analyticsConfigurationFilterToKotlin
import com.pulumi.aws.s3.kotlin.outputs.AnalyticsConfigurationStorageClassAnalysis.Companion.toKotlin as analyticsConfigurationStorageClassAnalysisToKotlin

/**
 * Builder for [AnalyticsConfiguration].
 */
@PulumiTagMarker
public class AnalyticsConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AnalyticsConfigurationArgs = AnalyticsConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AnalyticsConfigurationArgsBuilder.() -> Unit) {
        val builder = AnalyticsConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AnalyticsConfiguration {
        val builtJavaResource = com.pulumi.aws.s3.AnalyticsConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AnalyticsConfiguration(builtJavaResource)
    }
}

/**
 * Provides a S3 bucket [analytics configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html) resource.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Add analytics configuration for entire S3 bucket and export results to a second S3 bucket
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.AnalyticsConfiguration;
 * import com.pulumi.aws.s3.AnalyticsConfigurationArgs;
 * import com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisArgs;
 * import com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportArgs;
 * import com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs;
 * import com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example");
 *         var analytics = new BucketV2("analytics");
 *         var example_entire_bucket = new AnalyticsConfiguration("example-entire-bucket", AnalyticsConfigurationArgs.builder()
 *             .bucket(example.id())
 *             .storageClassAnalysis(AnalyticsConfigurationStorageClassAnalysisArgs.builder()
 *                 .dataExport(AnalyticsConfigurationStorageClassAnalysisDataExportArgs.builder()
 *                     .destination(AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs.builder()
 *                         .s3BucketDestination(AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs.builder()
 *                             .bucketArn(analytics.arn())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Add analytics configuration with S3 object filter
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.AnalyticsConfiguration;
 * import com.pulumi.aws.s3.AnalyticsConfigurationArgs;
 * import com.pulumi.aws.s3.inputs.AnalyticsConfigurationFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example");
 *         var example_filtered = new AnalyticsConfiguration("example-filtered", AnalyticsConfigurationArgs.builder()
 *             .bucket(example.id())
 *             .filter(AnalyticsConfigurationFilterArgs.builder()
 *                 .prefix("documents/")
 *                 .tags(Map.ofEntries(
 *                     Map.entry("priority", "high"),
 *                     Map.entry("class", "blue")
 *                 ))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 bucket analytics configurations using `bucket:analytics`. For example:
 * ```sh
 *  $ pulumi import aws:s3/analyticsConfiguration:AnalyticsConfiguration my-bucket-entire-bucket my-bucket:EntireBucket
 * ```
 *
 */
public class AnalyticsConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.s3.AnalyticsConfiguration,
) : KotlinCustomResource(javaResource, AnalyticsConfigurationMapper) {
    /**
     * Name of the bucket this analytics configuration is associated with.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Object filtering that accepts a prefix, tags, or a logical AND of prefix and tags (documented below).
     */
    public val filter: Output<AnalyticsConfigurationFilter>?
        get() = javaResource.filter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    analyticsConfigurationFilterToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Unique identifier of the analytics configuration for the bucket.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configuration for the analytics data export (documented below).
     */
    public val storageClassAnalysis: Output<AnalyticsConfigurationStorageClassAnalysis>?
        get() = javaResource.storageClassAnalysis().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    analyticsConfigurationStorageClassAnalysisToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object AnalyticsConfigurationMapper : ResourceMapper<AnalyticsConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.AnalyticsConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): AnalyticsConfiguration =
        AnalyticsConfiguration(javaResource as com.pulumi.aws.s3.AnalyticsConfiguration)
}

/**
 * @see [AnalyticsConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AnalyticsConfiguration].
 */
public suspend fun analyticsConfiguration(
    name: String,
    block: suspend AnalyticsConfigurationResourceBuilder.() -> Unit,
): AnalyticsConfiguration {
    val builder = AnalyticsConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AnalyticsConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun analyticsConfiguration(name: String): AnalyticsConfiguration {
    val builder = AnalyticsConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
