@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.AnalyticsConfigurationArgs.builder
import com.pulumi.aws.s3.kotlin.inputs.AnalyticsConfigurationFilterArgs
import com.pulumi.aws.s3.kotlin.inputs.AnalyticsConfigurationFilterArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.AnalyticsConfigurationStorageClassAnalysisArgs
import com.pulumi.aws.s3.kotlin.inputs.AnalyticsConfigurationStorageClassAnalysisArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a S3 bucket [analytics configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html) resource.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Add analytics configuration for entire S3 bucket and export results to a second S3 bucket
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.AnalyticsConfiguration;
 * import com.pulumi.aws.s3.AnalyticsConfigurationArgs;
 * import com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisArgs;
 * import com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportArgs;
 * import com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs;
 * import com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example");
 *         var analytics = new BucketV2("analytics");
 *         var example_entire_bucket = new AnalyticsConfiguration("example-entire-bucket", AnalyticsConfigurationArgs.builder()
 *             .bucket(example.id())
 *             .storageClassAnalysis(AnalyticsConfigurationStorageClassAnalysisArgs.builder()
 *                 .dataExport(AnalyticsConfigurationStorageClassAnalysisDataExportArgs.builder()
 *                     .destination(AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs.builder()
 *                         .s3BucketDestination(AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs.builder()
 *                             .bucketArn(analytics.arn())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Add analytics configuration with S3 object filter
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.AnalyticsConfiguration;
 * import com.pulumi.aws.s3.AnalyticsConfigurationArgs;
 * import com.pulumi.aws.s3.inputs.AnalyticsConfigurationFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example");
 *         var example_filtered = new AnalyticsConfiguration("example-filtered", AnalyticsConfigurationArgs.builder()
 *             .bucket(example.id())
 *             .filter(AnalyticsConfigurationFilterArgs.builder()
 *                 .prefix("documents/")
 *                 .tags(Map.ofEntries(
 *                     Map.entry("priority", "high"),
 *                     Map.entry("class", "blue")
 *                 ))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 bucket analytics configurations using `bucket:analytics`. For example:
 * ```sh
 *  $ pulumi import aws:s3/analyticsConfiguration:AnalyticsConfiguration my-bucket-entire-bucket my-bucket:EntireBucket
 * ```
 * @property bucket Name of the bucket this analytics configuration is associated with.
 * @property filter Object filtering that accepts a prefix, tags, or a logical AND of prefix and tags (documented below).
 * @property name Unique identifier of the analytics configuration for the bucket.
 * @property storageClassAnalysis Configuration for the analytics data export (documented below).
 */
public data class AnalyticsConfigurationArgs(
    public val bucket: Output<String>? = null,
    public val filter: Output<AnalyticsConfigurationFilterArgs>? = null,
    public val name: Output<String>? = null,
    public val storageClassAnalysis: Output<AnalyticsConfigurationStorageClassAnalysisArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.AnalyticsConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3.AnalyticsConfigurationArgs =
        com.pulumi.aws.s3.AnalyticsConfigurationArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .storageClassAnalysis(
                storageClassAnalysis?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AnalyticsConfigurationArgs].
 */
@PulumiTagMarker
public class AnalyticsConfigurationArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var filter: Output<AnalyticsConfigurationFilterArgs>? = null

    private var name: Output<String>? = null

    private var storageClassAnalysis: Output<AnalyticsConfigurationStorageClassAnalysisArgs>? = null

    /**
     * @param value Name of the bucket this analytics configuration is associated with.
     */
    @JvmName("onaunvglukhqgmor")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Object filtering that accepts a prefix, tags, or a logical AND of prefix and tags (documented below).
     */
    @JvmName("xvkmhbohrhwiainn")
    public suspend fun filter(`value`: Output<AnalyticsConfigurationFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value Unique identifier of the analytics configuration for the bucket.
     */
    @JvmName("qbstqdyjuapfapkw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration for the analytics data export (documented below).
     */
    @JvmName("qnruesogmfpccmxt")
    public suspend
    fun storageClassAnalysis(`value`: Output<AnalyticsConfigurationStorageClassAnalysisArgs>) {
        this.storageClassAnalysis = value
    }

    /**
     * @param value Name of the bucket this analytics configuration is associated with.
     */
    @JvmName("ftmceddjeglwlwuo")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Object filtering that accepts a prefix, tags, or a logical AND of prefix and tags (documented below).
     */
    @JvmName("oywpfkttncpiavpk")
    public suspend fun filter(`value`: AnalyticsConfigurationFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Object filtering that accepts a prefix, tags, or a logical AND of prefix and tags (documented below).
     */
    @JvmName("kxktooouwrdvhtsf")
    public suspend fun filter(argument: suspend AnalyticsConfigurationFilterArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsConfigurationFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value Unique identifier of the analytics configuration for the bucket.
     */
    @JvmName("uyioeyqnbwdlvbap")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration for the analytics data export (documented below).
     */
    @JvmName("aipnlfnsfgxxgdlt")
    public suspend
    fun storageClassAnalysis(`value`: AnalyticsConfigurationStorageClassAnalysisArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageClassAnalysis = mapped
    }

    /**
     * @param argument Configuration for the analytics data export (documented below).
     */
    @JvmName("vbatimqdwgnjbqip")
    public suspend
    fun storageClassAnalysis(argument: suspend AnalyticsConfigurationStorageClassAnalysisArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsConfigurationStorageClassAnalysisArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.storageClassAnalysis = mapped
    }

    internal fun build(): AnalyticsConfigurationArgs = AnalyticsConfigurationArgs(
        bucket = bucket,
        filter = filter,
        name = name,
        storageClassAnalysis = storageClassAnalysis,
    )
}
