@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.BucketCorsRule
import com.pulumi.aws.s3.kotlin.outputs.BucketGrant
import com.pulumi.aws.s3.kotlin.outputs.BucketLifecycleRule
import com.pulumi.aws.s3.kotlin.outputs.BucketLogging
import com.pulumi.aws.s3.kotlin.outputs.BucketObjectLockConfiguration
import com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfiguration
import com.pulumi.aws.s3.kotlin.outputs.BucketServerSideEncryptionConfiguration
import com.pulumi.aws.s3.kotlin.outputs.BucketVersioning
import com.pulumi.aws.s3.kotlin.outputs.BucketWebsite
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.s3.kotlin.outputs.BucketCorsRule.Companion.toKotlin as bucketCorsRuleToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketGrant.Companion.toKotlin as bucketGrantToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketLifecycleRule.Companion.toKotlin as bucketLifecycleRuleToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketLogging.Companion.toKotlin as bucketLoggingToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketObjectLockConfiguration.Companion.toKotlin as bucketObjectLockConfigurationToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfiguration.Companion.toKotlin as bucketReplicationConfigurationToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketServerSideEncryptionConfiguration.Companion.toKotlin as bucketServerSideEncryptionConfigurationToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketVersioning.Companion.toKotlin as bucketVersioningToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketWebsite.Companion.toKotlin as bucketWebsiteToKotlin

/**
 * Builder for [Bucket].
 */
@PulumiTagMarker
public class BucketResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketArgs = BucketArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketArgsBuilder.() -> Unit) {
        val builder = BucketArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Bucket {
        val builtJavaResource = com.pulumi.aws.s3.Bucket(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Bucket(builtJavaResource)
    }
}

/**
 * Provides a S3 bucket resource.
 * > This functionality is for managing S3 in an AWS Partition. To manage [S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html), see the `aws.s3control.Bucket` resource.
 * ## Example Usage
 * ### Private Bucket w/ Tags
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.Bucket;
 * import com.pulumi.aws.s3.BucketArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucket = new Bucket("bucket", BucketArgs.builder()
 *             .acl("private")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Environment", "Dev"),
 *                 Map.entry("Name", "My bucket")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Static Website Hosting
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.Bucket;
 * import com.pulumi.aws.s3.BucketArgs;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucket = new Bucket("bucket", BucketArgs.builder()
 *             .acl("public-read")
 *             .policy(Files.readString(Paths.get("policy.json")))
 *             .website(BucketWebsiteArgs.builder()
 *                 .indexDocument("index.html")
 *                 .errorDocument("error.html")
 *                 .routingRules("""
 * [{
 *     "Condition": {
 *         "KeyPrefixEquals": "docs/"
 *     },
 *     "Redirect": {
 *         "ReplaceKeyPrefixWith": "documents/"
 *     }
 * }]
 *                 """)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Using CORS
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.Bucket;
 * import com.pulumi.aws.s3.BucketArgs;
 * import com.pulumi.aws.s3.inputs.BucketCorsRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucket = new Bucket("bucket", BucketArgs.builder()
 *             .acl("public-read")
 *             .corsRules(BucketCorsRuleArgs.builder()
 *                 .allowedHeaders("*")
 *                 .allowedMethods(
 *                     "PUT",
 *                     "POST")
 *                 .allowedOrigins("https://s3-website-test.mydomain.com")
 *                 .exposeHeaders("ETag")
 *                 .maxAgeSeconds(3000)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Using versioning
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.Bucket;
 * import com.pulumi.aws.s3.BucketArgs;
 * import com.pulumi.aws.s3.inputs.BucketVersioningArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucket = new Bucket("bucket", BucketArgs.builder()
 *             .acl("private")
 *             .versioning(BucketVersioningArgs.builder()
 *                 .enabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Enable Logging
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.Bucket;
 * import com.pulumi.aws.s3.BucketArgs;
 * import com.pulumi.aws.s3.inputs.BucketLoggingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var logBucket = new Bucket("logBucket", BucketArgs.builder()
 *             .acl("log-delivery-write")
 *             .build());
 *         var bucket = new Bucket("bucket", BucketArgs.builder()
 *             .acl("private")
 *             .loggings(BucketLoggingArgs.builder()
 *                 .targetBucket(logBucket.id())
 *                 .targetPrefix("log/")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Using object lifecycle
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.Bucket;
 * import com.pulumi.aws.s3.BucketArgs;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleRuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleRuleExpirationArgs;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleRuleNoncurrentVersionExpirationArgs;
 * import com.pulumi.aws.s3.inputs.BucketVersioningArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucket = new Bucket("bucket", BucketArgs.builder()
 *             .acl("private")
 *             .lifecycleRules(
 *                 BucketLifecycleRuleArgs.builder()
 *                     .enabled(true)
 *                     .expiration(BucketLifecycleRuleExpirationArgs.builder()
 *                         .days(90)
 *                         .build())
 *                     .id("log")
 *                     .prefix("log/")
 *                     .tags(Map.ofEntries(
 *                         Map.entry("autoclean", "true"),
 *                         Map.entry("rule", "log")
 *                     ))
 *                     .transitions(
 *                         BucketLifecycleRuleTransitionArgs.builder()
 *                             .days(30)
 *                             .storageClass("STANDARD_IA")
 *                             .build(),
 *                         BucketLifecycleRuleTransitionArgs.builder()
 *                             .days(60)
 *                             .storageClass("GLACIER")
 *                             .build())
 *                     .build(),
 *                 BucketLifecycleRuleArgs.builder()
 *                     .enabled(true)
 *                     .expiration(BucketLifecycleRuleExpirationArgs.builder()
 *                         .date("2016-01-12")
 *                         .build())
 *                     .id("tmp")
 *                     .prefix("tmp/")
 *                     .build())
 *             .build());
 *         var versioningBucket = new Bucket("versioningBucket", BucketArgs.builder()
 *             .acl("private")
 *             .lifecycleRules(BucketLifecycleRuleArgs.builder()
 *                 .enabled(true)
 *                 .noncurrentVersionExpiration(BucketLifecycleRuleNoncurrentVersionExpirationArgs.builder()
 *                     .days(90)
 *                     .build())
 *                 .noncurrentVersionTransitions(
 *                     BucketLifecycleRuleNoncurrentVersionTransitionArgs.builder()
 *                         .days(30)
 *                         .storageClass("STANDARD_IA")
 *                         .build(),
 *                     BucketLifecycleRuleNoncurrentVersionTransitionArgs.builder()
 *                         .days(60)
 *                         .storageClass("GLACIER")
 *                         .build())
 *                 .prefix("config/")
 *                 .build())
 *             .versioning(BucketVersioningArgs.builder()
 *                 .enabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Using replication configuration
 * > **NOTE:** See the `aws.s3.BucketReplicationConfig` resource to support bi-directional replication configuration and additional features.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.s3.Bucket;
 * import com.pulumi.aws.s3.BucketArgs;
 * import com.pulumi.aws.s3.inputs.BucketVersioningArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigurationArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var central = new Provider("central", ProviderArgs.builder()
 *             .region("eu-central-1")
 *             .build());
 *         var replicationRole = new Role("replicationRole", RoleArgs.builder()
 *             .assumeRolePolicy("""
 * {
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Action": "sts:AssumeRole",
 *       "Principal": {
 *         "Service": "s3.amazonaws.com"
 *       },
 *       "Effect": "Allow",
 *       "Sid": ""
 *     }
 *   ]
 * }
 *             """)
 *             .build());
 *         var destination = new Bucket("destination", BucketArgs.builder()
 *             .versioning(BucketVersioningArgs.builder()
 *                 .enabled(true)
 *                 .build())
 *             .build());
 *         var source = new Bucket("source", BucketArgs.builder()
 *             .acl("private")
 *             .versioning(BucketVersioningArgs.builder()
 *                 .enabled(true)
 *                 .build())
 *             .replicationConfiguration(BucketReplicationConfigurationArgs.builder()
 *                 .role(replicationRole.arn())
 *                 .rules(BucketReplicationConfigurationRuleArgs.builder()
 *                     .id("foobar")
 *                     .status("Enabled")
 *                     .filter(BucketReplicationConfigurationRuleFilterArgs.builder()
 *                         .tags()
 *                         .build())
 *                     .destination(BucketReplicationConfigurationRuleDestinationArgs.builder()
 *                         .bucket(destination.arn())
 *                         .storageClass("STANDARD")
 *                         .replicationTime(BucketReplicationConfigurationRuleDestinationReplicationTimeArgs.builder()
 *                             .status("Enabled")
 *                             .minutes(15)
 *                             .build())
 *                         .metrics(BucketReplicationConfigurationRuleDestinationMetricsArgs.builder()
 *                             .status("Enabled")
 *                             .minutes(15)
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.central())
 *                 .build());
 *         var replicationPolicy = new Policy("replicationPolicy", PolicyArgs.builder()
 *             .policy(Output.tuple(source.arn(), source.arn(), destination.arn()).applyValue(values -> {
 *                 var sourceArn = values.t1;
 *                 var sourceArn1 = values.t2;
 *                 var destinationArn = values.t3;
 *                 return """
 * {
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Action": [
 *         "s3:GetReplicationConfiguration",
 *         "s3:ListBucket"
 *       ],
 *       "Effect": "Allow",
 *       "Resource": [
 *         "%s"
 *       ]
 *     },
 *     {
 *       "Action": [
 *         "s3:GetObjectVersionForReplication",
 *         "s3:GetObjectVersionAcl",
 *          "s3:GetObjectVersionTagging"
 *       ],
 *       "Effect": "Allow",
 *       "Resource": [
 *         "%s/*"
 *       ]
 *     },
 *     {
 *       "Action": [
 *         "s3:ReplicateObject",
 *         "s3:ReplicateDelete",
 *         "s3:ReplicateTags"
 *       ],
 *       "Effect": "Allow",
 *       "Resource": "%s/*"
 *     }
 *   ]
 * }
 * ", sourceArn,sourceArn1,destinationArn);
 *             }))
 *             .build());
 *         var replicationRolePolicyAttachment = new RolePolicyAttachment("replicationRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(replicationRole.name())
 *             .policyArn(replicationPolicy.arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Enable Default Server Side Encryption
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.s3.Bucket;
 * import com.pulumi.aws.s3.BucketArgs;
 * import com.pulumi.aws.s3.inputs.BucketServerSideEncryptionConfigurationArgs;
 * import com.pulumi.aws.s3.inputs.BucketServerSideEncryptionConfigurationRuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mykey = new Key("mykey", KeyArgs.builder()
 *             .description("This key is used to encrypt bucket objects")
 *             .deletionWindowInDays(10)
 *             .build());
 *         var mybucket = new Bucket("mybucket", BucketArgs.builder()
 *             .serverSideEncryptionConfiguration(BucketServerSideEncryptionConfigurationArgs.builder()
 *                 .rule(BucketServerSideEncryptionConfigurationRuleArgs.builder()
 *                     .applyServerSideEncryptionByDefault(BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs.builder()
 *                         .kmsMasterKeyId(mykey.arn())
 *                         .sseAlgorithm("aws:kms")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Using ACL policy grants
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.S3Functions;
 * import com.pulumi.aws.s3.Bucket;
 * import com.pulumi.aws.s3.BucketArgs;
 * import com.pulumi.aws.s3.inputs.BucketGrantArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentUser = S3Functions.getCanonicalUserId();
 *         var bucket = new Bucket("bucket", BucketArgs.builder()
 *             .grants(
 *                 BucketGrantArgs.builder()
 *                     .id(currentUser.applyValue(getCanonicalUserIdResult -> getCanonicalUserIdResult.id()))
 *                     .type("CanonicalUser")
 *                     .permissions("FULL_CONTROL")
 *                     .build(),
 *                 BucketGrantArgs.builder()
 *                     .type("Group")
 *                     .permissions(
 *                         "READ_ACP",
 *                         "WRITE")
 *                     .uri("http://acs.amazonaws.com/groups/s3/LogDelivery")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * S3 bucket can be imported using the `bucket`, e.g.,
 * ```sh
 *  $ pulumi import aws:s3/bucket:Bucket bucket bucket-name
 * ```
 *  The `policy` argument is not imported and will be deprecated in a future version of the provider. Use the `aws_s3_bucket_policy` resource to manage the S3 Bucket Policy instead.
 * */*/
 */
public class Bucket internal constructor(
    override val javaResource: com.pulumi.aws.s3.Bucket,
) : KotlinCustomResource(javaResource, BucketMapper) {
    /**
     * Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`.
     */
    public val accelerationStatus: Output<String>
        get() = javaResource.accelerationStatus().applyValue({ args0 -> args0 })

    /**
     * The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`.
     */
    public val acl: Output<String>?
        get() = javaResource.acl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ARN of the bucket. Will be of format `arn:aws:s3:::bucketname`.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the bucket. If omitted, this provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * The bucket domain name. Will be of format `bucketname.s3.amazonaws.com`.
     */
    public val bucketDomainName: Output<String>
        get() = javaResource.bucketDomainName().applyValue({ args0 -> args0 })

    /**
     * Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
     */
    public val bucketPrefix: Output<String>?
        get() = javaResource.bucketPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The bucket region-specific domain name. The bucket domain name including the region name, please refer [here](https://docs&#46;aws&#46;amazon&#46;com/general/latest/gr/rande&#46;html#s3_region) for format&#46; Note: The AWS CloudFront allows specifying S3 region-specific endpoint when creating S3 origin, it will prevent [redirect issues](https://forums.aws.amazon.com/thread.jspa?threadID=216814) from CloudFront to S3 Origin URL.
     */
    public val bucketRegionalDomainName: Output<String>
        get() = javaResource.bucketRegionalDomainName().applyValue({ args0 -> args0 })

    /**
     * A rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html) (documented below).
     */
    public val corsRules: Output<List<BucketCorsRule>>?
        get() = javaResource.corsRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> bucketCorsRuleToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket so that the bucket can be destroyed without error. These objects are *not* recoverable.
     */
    public val forceDestroy: Output<Boolean>?
        get() = javaResource.forceDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl) (documented below). Conflicts with `acl`.
     */
    public val grants: Output<List<BucketGrant>>?
        get() = javaResource.grants().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> bucketGrantToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The [Route 53 Hosted Zone ID](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_website_region_endpoints) for this bucket's region.
     */
    public val hostedZoneId: Output<String>
        get() = javaResource.hostedZoneId().applyValue({ args0 -> args0 })

    /**
     * A configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html) (documented below).
     */
    public val lifecycleRules: Output<List<BucketLifecycleRule>>?
        get() = javaResource.lifecycleRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        bucketLifecycleRuleToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A settings of [bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) (documented below).
     */
    public val loggings: Output<List<BucketLogging>>?
        get() = javaResource.loggings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> bucketLoggingToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html) (documented below)
     * > **NOTE:** You cannot use `acceleration_status` in `cn-north-1` or `us-gov-west-1`
     */
    public val objectLockConfiguration: Output<BucketObjectLockConfiguration>?
        get() = javaResource.objectLockConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> bucketObjectLockConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing in a `pulumi preview`. In this case, please make sure you use the verbose/specific version of the policy.
     */
    public val policy: Output<String>?
        get() = javaResource.policy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The AWS region this bucket resides in.
     */
    public val region: Output<String>
        get() = javaResource.region().applyValue({ args0 -> args0 })

    /**
     * A configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html) (documented below).
     */
    public val replicationConfiguration: Output<BucketReplicationConfiguration>?
        get() = javaResource.replicationConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> bucketReplicationConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies who should bear the cost of Amazon S3 data transfer.
     * Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur
     * the costs of any data transfer. See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html)
     * developer guide for more information.
     */
    public val requestPayer: Output<String>
        get() = javaResource.requestPayer().applyValue({ args0 -> args0 })

    /**
     * A configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html) (documented below)
     */
    public val serverSideEncryptionConfiguration: Output<BucketServerSideEncryptionConfiguration>
        get() = javaResource.serverSideEncryptionConfiguration().applyValue({ args0 ->
            args0.let({ args0 -> bucketServerSideEncryptionConfigurationToKotlin(args0) })
        })

    /**
     * A map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A state of [versioning](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html) (documented below)
     */
    public val versioning: Output<BucketVersioning>
        get() = javaResource.versioning().applyValue({ args0 ->
            args0.let({ args0 ->
                bucketVersioningToKotlin(args0)
            })
        })

    /**
     * A website object (documented below).
     */
    public val website: Output<BucketWebsite>?
        get() = javaResource.website().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bucketWebsiteToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string. This is used to create Route 53 alias records.
     */
    public val websiteDomain: Output<String>
        get() = javaResource.websiteDomain().applyValue({ args0 -> args0 })

    /**
     * The website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
     */
    public val websiteEndpoint: Output<String>
        get() = javaResource.websiteEndpoint().applyValue({ args0 -> args0 })
}

public object BucketMapper : ResourceMapper<Bucket> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.Bucket::class == javaResource::class

    override fun map(javaResource: Resource): Bucket = Bucket(
        javaResource as
            com.pulumi.aws.s3.Bucket,
    )
}

/**
 * @see [Bucket].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Bucket].
 */
public suspend fun bucket(name: String, block: suspend BucketResourceBuilder.() -> Unit): Bucket {
    val builder = BucketResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Bucket].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucket(name: String): Bucket {
    val builder = BucketResourceBuilder()
    builder.name(name)
    return builder.build()
}
