@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.BucketAccelerateConfigurationV2Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an S3 bucket accelerate configuration resource. See the [Requirements for using Transfer Acceleration](https://docs.aws.amazon.com/AmazonS3/latest/userguide/transfer-acceleration.html#transfer-acceleration-requirements) for more details.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketAccelerateConfigurationV2;
 * import com.pulumi.aws.s3.BucketAccelerateConfigurationV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mybucket = new BucketV2("mybucket");
 *         var example = new BucketAccelerateConfigurationV2("example", BucketAccelerateConfigurationV2Args.builder()
 *             .bucket(mybucket.id())
 *             .status("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * __Using `pulumi import` to import.__ For example:
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * ```sh
 *  $ pulumi import aws:s3/bucketAccelerateConfigurationV2:BucketAccelerateConfigurationV2 example bucket-name
 * ```
 *  If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * ```sh
 *  $ pulumi import aws:s3/bucketAccelerateConfigurationV2:BucketAccelerateConfigurationV2 example bucket-name,123456789012
 * ```
 * @property bucket Name of the bucket.
 * @property expectedBucketOwner Account ID of the expected bucket owner.
 * @property status Transfer acceleration state of the bucket. Valid values: `Enabled`, `Suspended`.
 */
public data class BucketAccelerateConfigurationV2Args(
    public val bucket: Output<String>? = null,
    public val expectedBucketOwner: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketAccelerateConfigurationV2Args> {
    override fun toJava(): com.pulumi.aws.s3.BucketAccelerateConfigurationV2Args =
        com.pulumi.aws.s3.BucketAccelerateConfigurationV2Args.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .expectedBucketOwner(expectedBucketOwner?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketAccelerateConfigurationV2Args].
 */
@PulumiTagMarker
public class BucketAccelerateConfigurationV2ArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var expectedBucketOwner: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value Name of the bucket.
     */
    @JvmName("krvgdjnnwoqeiuec")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Account ID of the expected bucket owner.
     */
    @JvmName("npkdpheqifkhvwpw")
    public suspend fun expectedBucketOwner(`value`: Output<String>) {
        this.expectedBucketOwner = value
    }

    /**
     * @param value Transfer acceleration state of the bucket. Valid values: `Enabled`, `Suspended`.
     */
    @JvmName("oujlsdgjvqtrxekv")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Name of the bucket.
     */
    @JvmName("xsnljoscbevlsoox")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Account ID of the expected bucket owner.
     */
    @JvmName("rtuwajuecfnsrotf")
    public suspend fun expectedBucketOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedBucketOwner = mapped
    }

    /**
     * @param value Transfer acceleration state of the bucket. Valid values: `Enabled`, `Suspended`.
     */
    @JvmName("vcvjwarrftxtpfyn")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): BucketAccelerateConfigurationV2Args = BucketAccelerateConfigurationV2Args(
        bucket = bucket,
        expectedBucketOwner = expectedBucketOwner,
        status = status,
    )
}
