@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.BucketAclV2AccessControlPolicy
import com.pulumi.aws.s3.kotlin.outputs.BucketAclV2AccessControlPolicy.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketAclV2].
 */
@PulumiTagMarker
public class BucketAclV2ResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketAclV2Args = BucketAclV2Args()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketAclV2ArgsBuilder.() -> Unit) {
        val builder = BucketAclV2ArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BucketAclV2 {
        val builtJavaResource = com.pulumi.aws.s3.BucketAclV2(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketAclV2(builtJavaResource)
    }
}

/**
 * Provides an S3 bucket ACL resource.
 * > **Note:** destroy does not delete the S3 Bucket ACL but does remove the resource from state.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### With `private` ACL
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketOwnershipControls;
 * import com.pulumi.aws.s3.BucketOwnershipControlsArgs;
 * import com.pulumi.aws.s3.inputs.BucketOwnershipControlsRuleArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketOwnershipControls = new BucketOwnershipControls("exampleBucketOwnershipControls", BucketOwnershipControlsArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .rule(BucketOwnershipControlsRuleArgs.builder()
 *                 .objectOwnership("BucketOwnerPreferred")
 *                 .build())
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("private")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleBucketOwnershipControls)
 *                 .build());
 *     }
 * }
 * ```
 * ### With `public-read` ACL
 * > This example explicitly disables the default S3 bucket security settings. This
 * should be done with caution, as all bucket objects become publicly exposed.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketOwnershipControls;
 * import com.pulumi.aws.s3.BucketOwnershipControlsArgs;
 * import com.pulumi.aws.s3.inputs.BucketOwnershipControlsRuleArgs;
 * import com.pulumi.aws.s3.BucketPublicAccessBlock;
 * import com.pulumi.aws.s3.BucketPublicAccessBlockArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketOwnershipControls = new BucketOwnershipControls("exampleBucketOwnershipControls", BucketOwnershipControlsArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .rule(BucketOwnershipControlsRuleArgs.builder()
 *                 .objectOwnership("BucketOwnerPreferred")
 *                 .build())
 *             .build());
 *         var exampleBucketPublicAccessBlock = new BucketPublicAccessBlock("exampleBucketPublicAccessBlock", BucketPublicAccessBlockArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .blockPublicAcls(false)
 *             .blockPublicPolicy(false)
 *             .ignorePublicAcls(false)
 *             .restrictPublicBuckets(false)
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("public-read")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     exampleBucketOwnershipControls,
 *                     exampleBucketPublicAccessBlock)
 *                 .build());
 *     }
 * }
 * ```
 * ### With Grants
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.S3Functions;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketOwnershipControls;
 * import com.pulumi.aws.s3.BucketOwnershipControlsArgs;
 * import com.pulumi.aws.s3.inputs.BucketOwnershipControlsRuleArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyArgs;
 * import com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyOwnerArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = S3Functions.getCanonicalUserId();
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketOwnershipControls = new BucketOwnershipControls("exampleBucketOwnershipControls", BucketOwnershipControlsArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .rule(BucketOwnershipControlsRuleArgs.builder()
 *                 .objectOwnership("BucketOwnerPreferred")
 *                 .build())
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .accessControlPolicy(BucketAclV2AccessControlPolicyArgs.builder()
 *                 .grants(
 *                     BucketAclV2AccessControlPolicyGrantArgs.builder()
 *                         .grantee(BucketAclV2AccessControlPolicyGrantGranteeArgs.builder()
 *                             .id(current.applyValue(getCanonicalUserIdResult -> getCanonicalUserIdResult.id()))
 *                             .type("CanonicalUser")
 *                             .build())
 *                         .permission("READ")
 *                         .build(),
 *                     BucketAclV2AccessControlPolicyGrantArgs.builder()
 *                         .grantee(BucketAclV2AccessControlPolicyGrantGranteeArgs.builder()
 *                             .type("Group")
 *                             .uri("http://acs.amazonaws.com/groups/s3/LogDelivery")
 *                             .build())
 *                         .permission("READ_ACP")
 *                         .build())
 *                 .owner(BucketAclV2AccessControlPolicyOwnerArgs.builder()
 *                     .id(current.applyValue(getCanonicalUserIdResult -> getCanonicalUserIdResult.id()))
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleBucketOwnershipControls)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * If the owner (account ID) of the source bucket is the _same_ account used to configure the AWS Provider, and the source bucket is __configured__ with a [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) (i.e. predefined grant), import using the `bucket` and `acl` separated by a comma (`,`):
 * If the owner (account ID) of the source bucket _differs_ from the account used to configure the AWS Provider, and the source bucket is __not configured__ with a [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) (i.e. predefined grant), imported using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * If the owner (account ID) of the source bucket _differs_ from the account used to configure the AWS Provider, and the source bucket is __configured__ with a [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) (i.e. predefined grant), imported using the `bucket`, `expected_bucket_owner`, and `acl` separated by commas (`,`):
 * __Using `pulumi import` to import__ using `bucket`, `expected_bucket_owner`, and/or `acl`, depending on your situation. For example:
 * If the owner (account ID) of the source bucket is the _same_ account used to configure the AWS Provider, and the source bucket is __not configured__ with a [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) (i.e. predefined grant), import using the `bucket`:
 * ```sh
 *  $ pulumi import aws:s3/bucketAclV2:BucketAclV2 example bucket-name
 * ```
 *  If the owner (account ID) of the source bucket is the _same_ account used to configure the AWS Provider, and the source bucket is __configured__ with a [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) (i.e. predefined grant), import using the `bucket` and `acl` separated by a comma (`,`):
 * ```sh
 *  $ pulumi import aws:s3/bucketAclV2:BucketAclV2 example bucket-name,private
 * ```
 *  If the owner (account ID) of the source bucket _differs_ from the account used to configure the AWS Provider, and the source bucket is __not configured__ with a [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) (i.e. predefined grant), imported using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * ```sh
 *  $ pulumi import aws:s3/bucketAclV2:BucketAclV2 example bucket-name,123456789012
 * ```
 *  If the owner (account ID) of the source bucket _differs_ from the account used to configure the AWS Provider, and the source bucket is __configured__ with a [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) (i.e. predefined grant), imported using the `bucket`, `expected_bucket_owner`, and `acl` separated by commas (`,`):
 * ```sh
 *  $ pulumi import aws:s3/bucketAclV2:BucketAclV2 example bucket-name,123456789012,private
 * ```
 *
 */
public class BucketAclV2 internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketAclV2,
) : KotlinCustomResource(javaResource, BucketAclV2Mapper) {
    /**
     * Configuration block that sets the ACL permissions for an object per grantee. See below.
     */
    public val accessControlPolicy: Output<BucketAclV2AccessControlPolicy>
        get() = javaResource.accessControlPolicy().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Canned ACL to apply to the bucket.
     */
    public val acl: Output<String>?
        get() = javaResource.acl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Account ID of the expected bucket owner.
     */
    public val expectedBucketOwner: Output<String>?
        get() = javaResource.expectedBucketOwner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object BucketAclV2Mapper : ResourceMapper<BucketAclV2> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketAclV2::class == javaResource::class

    override fun map(javaResource: Resource): BucketAclV2 = BucketAclV2(
        javaResource as
            com.pulumi.aws.s3.BucketAclV2,
    )
}

/**
 * @see [BucketAclV2].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketAclV2].
 */
public suspend fun bucketAclV2(name: String, block: suspend BucketAclV2ResourceBuilder.() -> Unit):
    BucketAclV2 {
    val builder = BucketAclV2ResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketAclV2].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketAclV2(name: String): BucketAclV2 {
    val builder = BucketAclV2ResourceBuilder()
    builder.name(name)
    return builder.build()
}
