@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.BucketAclV2Args.builder
import com.pulumi.aws.s3.kotlin.inputs.BucketAclV2AccessControlPolicyArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketAclV2AccessControlPolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an S3 bucket ACL resource.
 * > **Note:** destroy does not delete the S3 Bucket ACL but does remove the resource from state.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### With `private` ACL
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketOwnershipControls;
 * import com.pulumi.aws.s3.BucketOwnershipControlsArgs;
 * import com.pulumi.aws.s3.inputs.BucketOwnershipControlsRuleArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketOwnershipControls = new BucketOwnershipControls("exampleBucketOwnershipControls", BucketOwnershipControlsArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .rule(BucketOwnershipControlsRuleArgs.builder()
 *                 .objectOwnership("BucketOwnerPreferred")
 *                 .build())
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("private")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleBucketOwnershipControls)
 *                 .build());
 *     }
 * }
 * ```
 * ### With `public-read` ACL
 * > This example explicitly disables the default S3 bucket security settings. This
 * should be done with caution, as all bucket objects become publicly exposed.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketOwnershipControls;
 * import com.pulumi.aws.s3.BucketOwnershipControlsArgs;
 * import com.pulumi.aws.s3.inputs.BucketOwnershipControlsRuleArgs;
 * import com.pulumi.aws.s3.BucketPublicAccessBlock;
 * import com.pulumi.aws.s3.BucketPublicAccessBlockArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketOwnershipControls = new BucketOwnershipControls("exampleBucketOwnershipControls", BucketOwnershipControlsArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .rule(BucketOwnershipControlsRuleArgs.builder()
 *                 .objectOwnership("BucketOwnerPreferred")
 *                 .build())
 *             .build());
 *         var exampleBucketPublicAccessBlock = new BucketPublicAccessBlock("exampleBucketPublicAccessBlock", BucketPublicAccessBlockArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .blockPublicAcls(false)
 *             .blockPublicPolicy(false)
 *             .ignorePublicAcls(false)
 *             .restrictPublicBuckets(false)
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("public-read")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     exampleBucketOwnershipControls,
 *                     exampleBucketPublicAccessBlock)
 *                 .build());
 *     }
 * }
 * ```
 * ### With Grants
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.S3Functions;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketOwnershipControls;
 * import com.pulumi.aws.s3.BucketOwnershipControlsArgs;
 * import com.pulumi.aws.s3.inputs.BucketOwnershipControlsRuleArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyArgs;
 * import com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyOwnerArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = S3Functions.getCanonicalUserId();
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketOwnershipControls = new BucketOwnershipControls("exampleBucketOwnershipControls", BucketOwnershipControlsArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .rule(BucketOwnershipControlsRuleArgs.builder()
 *                 .objectOwnership("BucketOwnerPreferred")
 *                 .build())
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .accessControlPolicy(BucketAclV2AccessControlPolicyArgs.builder()
 *                 .grants(
 *                     BucketAclV2AccessControlPolicyGrantArgs.builder()
 *                         .grantee(BucketAclV2AccessControlPolicyGrantGranteeArgs.builder()
 *                             .id(current.applyValue(getCanonicalUserIdResult -> getCanonicalUserIdResult.id()))
 *                             .type("CanonicalUser")
 *                             .build())
 *                         .permission("READ")
 *                         .build(),
 *                     BucketAclV2AccessControlPolicyGrantArgs.builder()
 *                         .grantee(BucketAclV2AccessControlPolicyGrantGranteeArgs.builder()
 *                             .type("Group")
 *                             .uri("http://acs.amazonaws.com/groups/s3/LogDelivery")
 *                             .build())
 *                         .permission("READ_ACP")
 *                         .build())
 *                 .owner(BucketAclV2AccessControlPolicyOwnerArgs.builder()
 *                     .id(current.applyValue(getCanonicalUserIdResult -> getCanonicalUserIdResult.id()))
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleBucketOwnershipControls)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * If the owner (account ID) of the source bucket is the _same_ account used to configure the AWS Provider, and the source bucket is __configured__ with a [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) (i.e. predefined grant), import using the `bucket` and `acl` separated by a comma (`,`):
 * If the owner (account ID) of the source bucket _differs_ from the account used to configure the AWS Provider, and the source bucket is __not configured__ with a [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) (i.e. predefined grant), imported using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * If the owner (account ID) of the source bucket _differs_ from the account used to configure the AWS Provider, and the source bucket is __configured__ with a [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) (i.e. predefined grant), imported using the `bucket`, `expected_bucket_owner`, and `acl` separated by commas (`,`):
 * __Using `pulumi import` to import__ using `bucket`, `expected_bucket_owner`, and/or `acl`, depending on your situation. For example:
 * If the owner (account ID) of the source bucket is the _same_ account used to configure the AWS Provider, and the source bucket is __not configured__ with a [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) (i.e. predefined grant), import using the `bucket`:
 * ```sh
 *  $ pulumi import aws:s3/bucketAclV2:BucketAclV2 example bucket-name
 * ```
 *  If the owner (account ID) of the source bucket is the _same_ account used to configure the AWS Provider, and the source bucket is __configured__ with a [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) (i.e. predefined grant), import using the `bucket` and `acl` separated by a comma (`,`):
 * ```sh
 *  $ pulumi import aws:s3/bucketAclV2:BucketAclV2 example bucket-name,private
 * ```
 *  If the owner (account ID) of the source bucket _differs_ from the account used to configure the AWS Provider, and the source bucket is __not configured__ with a [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) (i.e. predefined grant), imported using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * ```sh
 *  $ pulumi import aws:s3/bucketAclV2:BucketAclV2 example bucket-name,123456789012
 * ```
 *  If the owner (account ID) of the source bucket _differs_ from the account used to configure the AWS Provider, and the source bucket is __configured__ with a [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) (i.e. predefined grant), imported using the `bucket`, `expected_bucket_owner`, and `acl` separated by commas (`,`):
 * ```sh
 *  $ pulumi import aws:s3/bucketAclV2:BucketAclV2 example bucket-name,123456789012,private
 * ```
 * @property accessControlPolicy Configuration block that sets the ACL permissions for an object per grantee. See below.
 * @property acl Canned ACL to apply to the bucket.
 * @property bucket Name of the bucket.
 * @property expectedBucketOwner Account ID of the expected bucket owner.
 */
public data class BucketAclV2Args(
    public val accessControlPolicy: Output<BucketAclV2AccessControlPolicyArgs>? = null,
    public val acl: Output<String>? = null,
    public val bucket: Output<String>? = null,
    public val expectedBucketOwner: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketAclV2Args> {
    override fun toJava(): com.pulumi.aws.s3.BucketAclV2Args =
        com.pulumi.aws.s3.BucketAclV2Args.builder()
            .accessControlPolicy(
                accessControlPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .acl(acl?.applyValue({ args0 -> args0 }))
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .expectedBucketOwner(expectedBucketOwner?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketAclV2Args].
 */
@PulumiTagMarker
public class BucketAclV2ArgsBuilder internal constructor() {
    private var accessControlPolicy: Output<BucketAclV2AccessControlPolicyArgs>? = null

    private var acl: Output<String>? = null

    private var bucket: Output<String>? = null

    private var expectedBucketOwner: Output<String>? = null

    /**
     * @param value Configuration block that sets the ACL permissions for an object per grantee. See below.
     */
    @JvmName("rbhtivdrjnluekqy")
    public suspend fun accessControlPolicy(`value`: Output<BucketAclV2AccessControlPolicyArgs>) {
        this.accessControlPolicy = value
    }

    /**
     * @param value Canned ACL to apply to the bucket.
     */
    @JvmName("tkxvvakbxcuebrdp")
    public suspend fun acl(`value`: Output<String>) {
        this.acl = value
    }

    /**
     * @param value Name of the bucket.
     */
    @JvmName("mdqrnqpamncufcov")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Account ID of the expected bucket owner.
     */
    @JvmName("wnpbysxitpuyhdmv")
    public suspend fun expectedBucketOwner(`value`: Output<String>) {
        this.expectedBucketOwner = value
    }

    /**
     * @param value Configuration block that sets the ACL permissions for an object per grantee. See below.
     */
    @JvmName("dbuyyiivlmyrpsje")
    public suspend fun accessControlPolicy(`value`: BucketAclV2AccessControlPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessControlPolicy = mapped
    }

    /**
     * @param argument Configuration block that sets the ACL permissions for an object per grantee. See below.
     */
    @JvmName("vdafldwhcwdcxkyb")
    public suspend
    fun accessControlPolicy(argument: suspend BucketAclV2AccessControlPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = BucketAclV2AccessControlPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessControlPolicy = mapped
    }

    /**
     * @param value Canned ACL to apply to the bucket.
     */
    @JvmName("ucqgvcdirxqwsisc")
    public suspend fun acl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acl = mapped
    }

    /**
     * @param value Name of the bucket.
     */
    @JvmName("pfohjsprjcgljjru")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Account ID of the expected bucket owner.
     */
    @JvmName("hteymtwnnkbpyqet")
    public suspend fun expectedBucketOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedBucketOwner = mapped
    }

    internal fun build(): BucketAclV2Args = BucketAclV2Args(
        accessControlPolicy = accessControlPolicy,
        acl = acl,
        bucket = bucket,
        expectedBucketOwner = expectedBucketOwner,
    )
}
