@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.BucketIntelligentTieringConfigurationFilter
import com.pulumi.aws.s3.kotlin.outputs.BucketIntelligentTieringConfigurationTiering
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.s3.kotlin.outputs.BucketIntelligentTieringConfigurationFilter.Companion.toKotlin as bucketIntelligentTieringConfigurationFilterToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketIntelligentTieringConfigurationTiering.Companion.toKotlin as bucketIntelligentTieringConfigurationTieringToKotlin

/**
 * Builder for [BucketIntelligentTieringConfiguration].
 */
@PulumiTagMarker
public class BucketIntelligentTieringConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketIntelligentTieringConfigurationArgs =
        BucketIntelligentTieringConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend BucketIntelligentTieringConfigurationArgsBuilder.() -> Unit) {
        val builder = BucketIntelligentTieringConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BucketIntelligentTieringConfiguration {
        val builtJavaResource =
            com.pulumi.aws.s3.BucketIntelligentTieringConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BucketIntelligentTieringConfiguration(builtJavaResource)
    }
}

/**
 * Provides an [S3 Intelligent-Tiering](https://docs.aws.amazon.com/AmazonS3/latest/userguide/intelligent-tiering.html) configuration resource.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Add intelligent tiering configuration for entire S3 bucket
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketIntelligentTieringConfiguration;
 * import com.pulumi.aws.s3.BucketIntelligentTieringConfigurationArgs;
 * import com.pulumi.aws.s3.inputs.BucketIntelligentTieringConfigurationTieringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example");
 *         var example_entire_bucket = new BucketIntelligentTieringConfiguration("example-entire-bucket", BucketIntelligentTieringConfigurationArgs.builder()
 *             .bucket(example.id())
 *             .tierings(
 *                 BucketIntelligentTieringConfigurationTieringArgs.builder()
 *                     .accessTier("DEEP_ARCHIVE_ACCESS")
 *                     .days(180)
 *                     .build(),
 *                 BucketIntelligentTieringConfigurationTieringArgs.builder()
 *                     .accessTier("ARCHIVE_ACCESS")
 *                     .days(125)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Add intelligent tiering configuration with S3 object filter
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketIntelligentTieringConfiguration;
 * import com.pulumi.aws.s3.BucketIntelligentTieringConfigurationArgs;
 * import com.pulumi.aws.s3.inputs.BucketIntelligentTieringConfigurationFilterArgs;
 * import com.pulumi.aws.s3.inputs.BucketIntelligentTieringConfigurationTieringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example");
 *         var example_filtered = new BucketIntelligentTieringConfiguration("example-filtered", BucketIntelligentTieringConfigurationArgs.builder()
 *             .bucket(example.id())
 *             .status("Disabled")
 *             .filter(BucketIntelligentTieringConfigurationFilterArgs.builder()
 *                 .prefix("documents/")
 *                 .tags(Map.ofEntries(
 *                     Map.entry("priority", "high"),
 *                     Map.entry("class", "blue")
 *                 ))
 *                 .build())
 *             .tierings(BucketIntelligentTieringConfigurationTieringArgs.builder()
 *                 .accessTier("ARCHIVE_ACCESS")
 *                 .days(125)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 bucket intelligent tiering configurations using `bucket:name`. For example:
 * ```sh
 *  $ pulumi import aws:s3/bucketIntelligentTieringConfiguration:BucketIntelligentTieringConfiguration my-bucket-entire-bucket my-bucket:EntireBucket
 * ```
 *
 */
public class BucketIntelligentTieringConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketIntelligentTieringConfiguration,
) : KotlinCustomResource(javaResource, BucketIntelligentTieringConfigurationMapper) {
    /**
     * Name of the bucket this intelligent tiering configuration is associated with.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Bucket filter. The configuration only includes objects that meet the filter's criteria (documented below).
     */
    public val filter: Output<BucketIntelligentTieringConfigurationFilter>?
        get() = javaResource.filter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bucketIntelligentTieringConfigurationFilterToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Unique name used to identify the S3 Intelligent-Tiering configuration for the bucket.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the status of the configuration. Valid values: `Enabled`, `Disabled`.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * S3 Intelligent-Tiering storage class tiers of the configuration (documented below).
     */
    public val tierings: Output<List<BucketIntelligentTieringConfigurationTiering>>
        get() = javaResource.tierings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bucketIntelligentTieringConfigurationTieringToKotlin(args0)
                })
            })
        })
}

public object BucketIntelligentTieringConfigurationMapper :
    ResourceMapper<BucketIntelligentTieringConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketIntelligentTieringConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): BucketIntelligentTieringConfiguration =
        BucketIntelligentTieringConfiguration(
            javaResource as
                com.pulumi.aws.s3.BucketIntelligentTieringConfiguration,
        )
}

/**
 * @see [BucketIntelligentTieringConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketIntelligentTieringConfiguration].
 */
public suspend fun bucketIntelligentTieringConfiguration(
    name: String,
    block: suspend BucketIntelligentTieringConfigurationResourceBuilder.() -> Unit,
):
    BucketIntelligentTieringConfiguration {
    val builder = BucketIntelligentTieringConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketIntelligentTieringConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketIntelligentTieringConfiguration(name: String):
    BucketIntelligentTieringConfiguration {
    val builder = BucketIntelligentTieringConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
