@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.BucketIntelligentTieringConfigurationArgs.builder
import com.pulumi.aws.s3.kotlin.inputs.BucketIntelligentTieringConfigurationFilterArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketIntelligentTieringConfigurationFilterArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketIntelligentTieringConfigurationTieringArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketIntelligentTieringConfigurationTieringArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an [S3 Intelligent-Tiering](https://docs.aws.amazon.com/AmazonS3/latest/userguide/intelligent-tiering.html) configuration resource.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Add intelligent tiering configuration for entire S3 bucket
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketIntelligentTieringConfiguration;
 * import com.pulumi.aws.s3.BucketIntelligentTieringConfigurationArgs;
 * import com.pulumi.aws.s3.inputs.BucketIntelligentTieringConfigurationTieringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example");
 *         var example_entire_bucket = new BucketIntelligentTieringConfiguration("example-entire-bucket", BucketIntelligentTieringConfigurationArgs.builder()
 *             .bucket(example.id())
 *             .tierings(
 *                 BucketIntelligentTieringConfigurationTieringArgs.builder()
 *                     .accessTier("DEEP_ARCHIVE_ACCESS")
 *                     .days(180)
 *                     .build(),
 *                 BucketIntelligentTieringConfigurationTieringArgs.builder()
 *                     .accessTier("ARCHIVE_ACCESS")
 *                     .days(125)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Add intelligent tiering configuration with S3 object filter
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketIntelligentTieringConfiguration;
 * import com.pulumi.aws.s3.BucketIntelligentTieringConfigurationArgs;
 * import com.pulumi.aws.s3.inputs.BucketIntelligentTieringConfigurationFilterArgs;
 * import com.pulumi.aws.s3.inputs.BucketIntelligentTieringConfigurationTieringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example");
 *         var example_filtered = new BucketIntelligentTieringConfiguration("example-filtered", BucketIntelligentTieringConfigurationArgs.builder()
 *             .bucket(example.id())
 *             .status("Disabled")
 *             .filter(BucketIntelligentTieringConfigurationFilterArgs.builder()
 *                 .prefix("documents/")
 *                 .tags(Map.ofEntries(
 *                     Map.entry("priority", "high"),
 *                     Map.entry("class", "blue")
 *                 ))
 *                 .build())
 *             .tierings(BucketIntelligentTieringConfigurationTieringArgs.builder()
 *                 .accessTier("ARCHIVE_ACCESS")
 *                 .days(125)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 bucket intelligent tiering configurations using `bucket:name`. For example:
 * ```sh
 *  $ pulumi import aws:s3/bucketIntelligentTieringConfiguration:BucketIntelligentTieringConfiguration my-bucket-entire-bucket my-bucket:EntireBucket
 * ```
 * @property bucket Name of the bucket this intelligent tiering configuration is associated with.
 * @property filter Bucket filter. The configuration only includes objects that meet the filter's criteria (documented below).
 * @property name Unique name used to identify the S3 Intelligent-Tiering configuration for the bucket.
 * @property status Specifies the status of the configuration. Valid values: `Enabled`, `Disabled`.
 * @property tierings S3 Intelligent-Tiering storage class tiers of the configuration (documented below).
 */
public data class BucketIntelligentTieringConfigurationArgs(
    public val bucket: Output<String>? = null,
    public val filter: Output<BucketIntelligentTieringConfigurationFilterArgs>? = null,
    public val name: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tierings: Output<List<BucketIntelligentTieringConfigurationTieringArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketIntelligentTieringConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3.BucketIntelligentTieringConfigurationArgs =
        com.pulumi.aws.s3.BucketIntelligentTieringConfigurationArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tierings(
                tierings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketIntelligentTieringConfigurationArgs].
 */
@PulumiTagMarker
public class BucketIntelligentTieringConfigurationArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var filter: Output<BucketIntelligentTieringConfigurationFilterArgs>? = null

    private var name: Output<String>? = null

    private var status: Output<String>? = null

    private var tierings: Output<List<BucketIntelligentTieringConfigurationTieringArgs>>? = null

    /**
     * @param value Name of the bucket this intelligent tiering configuration is associated with.
     */
    @JvmName("bajfviwtrpddinem")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Bucket filter. The configuration only includes objects that meet the filter's criteria (documented below).
     */
    @JvmName("ccakdbsficcpxymw")
    public suspend fun filter(`value`: Output<BucketIntelligentTieringConfigurationFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value Unique name used to identify the S3 Intelligent-Tiering configuration for the bucket.
     */
    @JvmName("bfjmadjqvkpckxay")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the status of the configuration. Valid values: `Enabled`, `Disabled`.
     */
    @JvmName("csdjyvfdklovtcps")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value S3 Intelligent-Tiering storage class tiers of the configuration (documented below).
     */
    @JvmName("cxdgsfvslrduaade")
    public suspend
    fun tierings(`value`: Output<List<BucketIntelligentTieringConfigurationTieringArgs>>) {
        this.tierings = value
    }

    @JvmName("pewmmlafnoaepndu")
    public suspend fun tierings(
        vararg
        values: Output<BucketIntelligentTieringConfigurationTieringArgs>,
    ) {
        this.tierings = Output.all(values.asList())
    }

    /**
     * @param values S3 Intelligent-Tiering storage class tiers of the configuration (documented below).
     */
    @JvmName("qlugwqygxmilchlj")
    public suspend
    fun tierings(values: List<Output<BucketIntelligentTieringConfigurationTieringArgs>>) {
        this.tierings = Output.all(values)
    }

    /**
     * @param value Name of the bucket this intelligent tiering configuration is associated with.
     */
    @JvmName("wmvambggrvxqomcq")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Bucket filter. The configuration only includes objects that meet the filter's criteria (documented below).
     */
    @JvmName("icoftmwpyxriwnqh")
    public suspend fun filter(`value`: BucketIntelligentTieringConfigurationFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Bucket filter. The configuration only includes objects that meet the filter's criteria (documented below).
     */
    @JvmName("wpaycdrwdsyrroum")
    public suspend
    fun filter(argument: suspend BucketIntelligentTieringConfigurationFilterArgsBuilder.() -> Unit) {
        val toBeMapped = BucketIntelligentTieringConfigurationFilterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value Unique name used to identify the S3 Intelligent-Tiering configuration for the bucket.
     */
    @JvmName("fljqfyncplqwtocr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the status of the configuration. Valid values: `Enabled`, `Disabled`.
     */
    @JvmName("thfetndljwqowqje")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value S3 Intelligent-Tiering storage class tiers of the configuration (documented below).
     */
    @JvmName("bnauypkuxaedumdj")
    public suspend fun tierings(`value`: List<BucketIntelligentTieringConfigurationTieringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tierings = mapped
    }

    /**
     * @param argument S3 Intelligent-Tiering storage class tiers of the configuration (documented below).
     */
    @JvmName("iqiijnnogehgwqsg")
    public suspend
    fun tierings(argument: List<suspend BucketIntelligentTieringConfigurationTieringArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketIntelligentTieringConfigurationTieringArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tierings = mapped
    }

    /**
     * @param argument S3 Intelligent-Tiering storage class tiers of the configuration (documented below).
     */
    @JvmName("etrxwqxktkwxxpjp")
    public suspend fun tierings(
        vararg
        argument: suspend BucketIntelligentTieringConfigurationTieringArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketIntelligentTieringConfigurationTieringArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tierings = mapped
    }

    /**
     * @param argument S3 Intelligent-Tiering storage class tiers of the configuration (documented below).
     */
    @JvmName("retebhvecouenrwk")
    public suspend
    fun tierings(argument: suspend BucketIntelligentTieringConfigurationTieringArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketIntelligentTieringConfigurationTieringArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.tierings = mapped
    }

    /**
     * @param values S3 Intelligent-Tiering storage class tiers of the configuration (documented below).
     */
    @JvmName("yjdggoepydlattqm")
    public suspend fun tierings(vararg values: BucketIntelligentTieringConfigurationTieringArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tierings = mapped
    }

    internal fun build(): BucketIntelligentTieringConfigurationArgs =
        BucketIntelligentTieringConfigurationArgs(
            bucket = bucket,
            filter = filter,
            name = name,
            status = status,
            tierings = tierings,
        )
}
