@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.BucketLifecycleConfigurationV2Rule
import com.pulumi.aws.s3.kotlin.outputs.BucketLifecycleConfigurationV2Rule.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BucketLifecycleConfigurationV2].
 */
@PulumiTagMarker
public class BucketLifecycleConfigurationV2ResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketLifecycleConfigurationV2Args = BucketLifecycleConfigurationV2Args()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketLifecycleConfigurationV2ArgsBuilder.() -> Unit) {
        val builder = BucketLifecycleConfigurationV2ArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BucketLifecycleConfigurationV2 {
        val builtJavaResource =
            com.pulumi.aws.s3.BucketLifecycleConfigurationV2(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BucketLifecycleConfigurationV2(builtJavaResource)
    }
}

/**
 * Provides an independent configuration resource for S3 bucket [lifecycle configuration](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lifecycle-mgmt.html).
 * An S3 Lifecycle configuration consists of one or more Lifecycle rules. Each rule consists of the following:
 * * Rule metadata (`id` and `status`)
 * * Filter identifying objects to which the rule applies
 * * One or more transition or expiration actions
 * For more information see the Amazon S3 User Guide on [`Lifecycle Configuration Elements`](https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html).
 * > **NOTE:** S3 Buckets only support a single lifecycle configuration. Declaring multiple `aws.s3.BucketLifecycleConfigurationV2` resources to the same S3 Bucket will cause a perpetual difference in configuration.
 * > **NOTE:** Lifecycle configurations may take some time to fully propagate to all AWS S3 systems.
 * Running Pulumi operations shortly after creating a lifecycle configuration may result in changes that affect configuration idempotence.
 * See the Amazon S3 User Guide on [setting lifecycle configuration on a bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/how-to-set-lifecycle-configuration-intro.html).
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### With neither a filter nor prefix specified
 * The Lifecycle rule applies to a subset of objects based on the key name prefix (`""`).
 * This configuration is intended to replicate the default behavior of the `lifecycle_rule`
 * parameter in the AWS Provider `aws.s3.BucketV2` resource prior to `v4.0`.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketLifecycleConfigurationV2;
 * import com.pulumi.aws.s3.BucketLifecycleConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketLifecycleConfigurationV2("example", BucketLifecycleConfigurationV2Args.builder()
 *             .bucket(aws_s3_bucket.bucket().id())
 *             .rules(BucketLifecycleConfigurationV2RuleArgs.builder()
 *                 .id("rule-1")
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Specifying an empty filter
 * The Lifecycle rule applies to all objects in the bucket.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketLifecycleConfigurationV2;
 * import com.pulumi.aws.s3.BucketLifecycleConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketLifecycleConfigurationV2("example", BucketLifecycleConfigurationV2Args.builder()
 *             .bucket(aws_s3_bucket.bucket().id())
 *             .rules(BucketLifecycleConfigurationV2RuleArgs.builder()
 *                 .id("rule-1")
 *                 .filter()
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Specifying a filter using key prefixes
 * The Lifecycle rule applies to a subset of objects based on the key name prefix (`logs/`).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketLifecycleConfigurationV2;
 * import com.pulumi.aws.s3.BucketLifecycleConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketLifecycleConfigurationV2("example", BucketLifecycleConfigurationV2Args.builder()
 *             .bucket(aws_s3_bucket.bucket().id())
 *             .rules(BucketLifecycleConfigurationV2RuleArgs.builder()
 *                 .id("rule-1")
 *                 .filter(BucketLifecycleConfigurationV2RuleFilterArgs.builder()
 *                     .prefix("logs/")
 *                     .build())
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Specifying a filter based on an object tag
 * The Lifecycle rule specifies a filter based on a tag key and value. The rule then applies only to a subset of objects with the specific tag.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketLifecycleConfigurationV2;
 * import com.pulumi.aws.s3.BucketLifecycleConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterArgs;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketLifecycleConfigurationV2("example", BucketLifecycleConfigurationV2Args.builder()
 *             .bucket(aws_s3_bucket.bucket().id())
 *             .rules(BucketLifecycleConfigurationV2RuleArgs.builder()
 *                 .id("rule-1")
 *                 .filter(BucketLifecycleConfigurationV2RuleFilterArgs.builder()
 *                     .tag(BucketLifecycleConfigurationV2RuleFilterTagArgs.builder()
 *                         .key("Name")
 *                         .value("Staging")
 *                         .build())
 *                     .build())
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Specifying a filter based on multiple tags
 * The Lifecycle rule directs Amazon S3 to perform lifecycle actions on objects with two tags (with the specific tag keys and values). Notice `tags` is wrapped in the `and` configuration block.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketLifecycleConfigurationV2;
 * import com.pulumi.aws.s3.BucketLifecycleConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterArgs;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterAndArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketLifecycleConfigurationV2("example", BucketLifecycleConfigurationV2Args.builder()
 *             .bucket(aws_s3_bucket.bucket().id())
 *             .rules(BucketLifecycleConfigurationV2RuleArgs.builder()
 *                 .id("rule-1")
 *                 .filter(BucketLifecycleConfigurationV2RuleFilterArgs.builder()
 *                     .and(BucketLifecycleConfigurationV2RuleFilterAndArgs.builder()
 *                         .tags(Map.ofEntries(
 *                             Map.entry("Key1", "Value1"),
 *                             Map.entry("Key2", "Value2")
 *                         ))
 *                         .build())
 *                     .build())
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Specifying a filter based on both prefix and one or more tags
 * The Lifecycle rule directs Amazon S3 to perform lifecycle actions on objects with the specified prefix and two tags (with the specific tag keys and values). Notice both `prefix` and `tags` are wrapped in the `and` configuration block.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketLifecycleConfigurationV2;
 * import com.pulumi.aws.s3.BucketLifecycleConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterArgs;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterAndArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketLifecycleConfigurationV2("example", BucketLifecycleConfigurationV2Args.builder()
 *             .bucket(aws_s3_bucket.bucket().id())
 *             .rules(BucketLifecycleConfigurationV2RuleArgs.builder()
 *                 .id("rule-1")
 *                 .filter(BucketLifecycleConfigurationV2RuleFilterArgs.builder()
 *                     .and(BucketLifecycleConfigurationV2RuleFilterAndArgs.builder()
 *                         .prefix("logs/")
 *                         .tags(Map.ofEntries(
 *                             Map.entry("Key1", "Value1"),
 *                             Map.entry("Key2", "Value2")
 *                         ))
 *                         .build())
 *                     .build())
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Specifying a filter based on object size
 * Object size values are in bytes. Maximum filter size is 5TB. Some storage classes have minimum object size limitations, for more information, see [Comparing the Amazon S3 storage classes](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-class-intro.html#sc-compare).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketLifecycleConfigurationV2;
 * import com.pulumi.aws.s3.BucketLifecycleConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketLifecycleConfigurationV2("example", BucketLifecycleConfigurationV2Args.builder()
 *             .bucket(aws_s3_bucket.bucket().id())
 *             .rules(BucketLifecycleConfigurationV2RuleArgs.builder()
 *                 .id("rule-1")
 *                 .filter(BucketLifecycleConfigurationV2RuleFilterArgs.builder()
 *                     .objectSizeGreaterThan(500)
 *                     .build())
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Specifying a filter based on object size range and prefix
 * The `object_size_greater_than` must be less than the `object_size_less_than`. Notice both the object size range and prefix are wrapped in the `and` configuration block.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketLifecycleConfigurationV2;
 * import com.pulumi.aws.s3.BucketLifecycleConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterArgs;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterAndArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketLifecycleConfigurationV2("example", BucketLifecycleConfigurationV2Args.builder()
 *             .bucket(aws_s3_bucket.bucket().id())
 *             .rules(BucketLifecycleConfigurationV2RuleArgs.builder()
 *                 .id("rule-1")
 *                 .filter(BucketLifecycleConfigurationV2RuleFilterArgs.builder()
 *                     .and(BucketLifecycleConfigurationV2RuleFilterAndArgs.builder()
 *                         .prefix("logs/")
 *                         .objectSizeGreaterThan(500)
 *                         .objectSizeLessThan(64000)
 *                         .build())
 *                     .build())
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Creating a Lifecycle Configuration for a bucket with versioning
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketLifecycleConfigurationV2;
 * import com.pulumi.aws.s3.BucketLifecycleConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleExpirationArgs;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterArgs;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleFilterAndArgs;
 * import com.pulumi.aws.s3.BucketVersioningV2;
 * import com.pulumi.aws.s3.BucketVersioningV2Args;
 * import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs;
 * import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleNoncurrentVersionExpirationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucket = new BucketV2("bucket");
 *         var bucketAcl = new BucketAclV2("bucketAcl", BucketAclV2Args.builder()
 *             .bucket(bucket.id())
 *             .acl("private")
 *             .build());
 *         var bucket_config = new BucketLifecycleConfigurationV2("bucket-config", BucketLifecycleConfigurationV2Args.builder()
 *             .bucket(bucket.id())
 *             .rules(
 *                 BucketLifecycleConfigurationV2RuleArgs.builder()
 *                     .id("log")
 *                     .expiration(BucketLifecycleConfigurationV2RuleExpirationArgs.builder()
 *                         .days(90)
 *                         .build())
 *                     .filter(BucketLifecycleConfigurationV2RuleFilterArgs.builder()
 *                         .and(BucketLifecycleConfigurationV2RuleFilterAndArgs.builder()
 *                             .prefix("log/")
 *                             .tags(Map.ofEntries(
 *                                 Map.entry("rule", "log"),
 *                                 Map.entry("autoclean", "true")
 *                             ))
 *                             .build())
 *                         .build())
 *                     .status("Enabled")
 *                     .transitions(
 *                         BucketLifecycleConfigurationV2RuleTransitionArgs.builder()
 *                             .days(30)
 *                             .storageClass("STANDARD_IA")
 *                             .build(),
 *                         BucketLifecycleConfigurationV2RuleTransitionArgs.builder()
 *                             .days(60)
 *                             .storageClass("GLACIER")
 *                             .build())
 *                     .build(),
 *                 BucketLifecycleConfigurationV2RuleArgs.builder()
 *                     .id("tmp")
 *                     .filter(BucketLifecycleConfigurationV2RuleFilterArgs.builder()
 *                         .prefix("tmp/")
 *                         .build())
 *                     .expiration(BucketLifecycleConfigurationV2RuleExpirationArgs.builder()
 *                         .date("2023-01-13T00:00:00Z")
 *                         .build())
 *                     .status("Enabled")
 *                     .build())
 *             .build());
 *         var versioningBucket = new BucketV2("versioningBucket");
 *         var versioningBucketAcl = new BucketAclV2("versioningBucketAcl", BucketAclV2Args.builder()
 *             .bucket(versioningBucket.id())
 *             .acl("private")
 *             .build());
 *         var versioning = new BucketVersioningV2("versioning", BucketVersioningV2Args.builder()
 *             .bucket(versioningBucket.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *         var versioning_bucket_config = new BucketLifecycleConfigurationV2("versioning-bucket-config", BucketLifecycleConfigurationV2Args.builder()
 *             .bucket(versioningBucket.id())
 *             .rules(BucketLifecycleConfigurationV2RuleArgs.builder()
 *                 .id("config")
 *                 .filter(BucketLifecycleConfigurationV2RuleFilterArgs.builder()
 *                     .prefix("config/")
 *                     .build())
 *                 .noncurrentVersionExpiration(BucketLifecycleConfigurationV2RuleNoncurrentVersionExpirationArgs.builder()
 *                     .noncurrentDays(90)
 *                     .build())
 *                 .noncurrentVersionTransitions(
 *                     BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgs.builder()
 *                         .noncurrentDays(30)
 *                         .storageClass("STANDARD_IA")
 *                         .build(),
 *                     BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgs.builder()
 *                         .noncurrentDays(60)
 *                         .storageClass("GLACIER")
 *                         .build())
 *                 .status("Enabled")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(versioning)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * __Using `pulumi import` to import__ S3 bucket lifecycle configuration using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * ```sh
 *  $ pulumi import aws:s3/bucketLifecycleConfigurationV2:BucketLifecycleConfigurationV2 example bucket-name
 * ```
 *  If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * ```sh
 *  $ pulumi import aws:s3/bucketLifecycleConfigurationV2:BucketLifecycleConfigurationV2 example bucket-name,123456789012
 * ```
 *
 */
public class BucketLifecycleConfigurationV2 internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketLifecycleConfigurationV2,
) : KotlinCustomResource(javaResource, BucketLifecycleConfigurationV2Mapper) {
    /**
     * Name of the source S3 bucket you want Amazon S3 to monitor.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
     */
    public val expectedBucketOwner: Output<String>?
        get() = javaResource.expectedBucketOwner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of configuration blocks describing the rules managing the replication. See below.
     */
    public val rules: Output<List<BucketLifecycleConfigurationV2Rule>>
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object BucketLifecycleConfigurationV2Mapper : ResourceMapper<BucketLifecycleConfigurationV2> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketLifecycleConfigurationV2::class == javaResource::class

    override fun map(javaResource: Resource): BucketLifecycleConfigurationV2 =
        BucketLifecycleConfigurationV2(
            javaResource as
                com.pulumi.aws.s3.BucketLifecycleConfigurationV2,
        )
}

/**
 * @see [BucketLifecycleConfigurationV2].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketLifecycleConfigurationV2].
 */
public suspend fun bucketLifecycleConfigurationV2(
    name: String,
    block: suspend BucketLifecycleConfigurationV2ResourceBuilder.() -> Unit,
):
    BucketLifecycleConfigurationV2 {
    val builder = BucketLifecycleConfigurationV2ResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketLifecycleConfigurationV2].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketLifecycleConfigurationV2(name: String): BucketLifecycleConfigurationV2 {
    val builder = BucketLifecycleConfigurationV2ResourceBuilder()
    builder.name(name)
    return builder.build()
}
