@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.BucketLoggingV2Args.builder
import com.pulumi.aws.s3.kotlin.inputs.BucketLoggingV2TargetGrantArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketLoggingV2TargetGrantArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketLoggingV2TargetObjectKeyFormatArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketLoggingV2TargetObjectKeyFormatArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an S3 bucket (server access) logging resource. For more information, see [Logging requests using server access logging](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerLogs.html)
 * in the AWS S3 User Guide.
 * > **Note:** Amazon S3 supports server access logging, AWS CloudTrail, or a combination of both. Refer to the [Logging options for Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/logging-with-S3.html)
 * to decide which method meets your requirements.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketLoggingV2;
 * import com.pulumi.aws.s3.BucketLoggingV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("private")
 *             .build());
 *         var logBucket = new BucketV2("logBucket");
 *         var logBucketAcl = new BucketAclV2("logBucketAcl", BucketAclV2Args.builder()
 *             .bucket(logBucket.id())
 *             .acl("log-delivery-write")
 *             .build());
 *         var exampleBucketLoggingV2 = new BucketLoggingV2("exampleBucketLoggingV2", BucketLoggingV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .targetBucket(logBucket.id())
 *             .targetPrefix("log/")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * __Using `pulumi import` to import__ S3 bucket logging using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * ```sh
 *  $ pulumi import aws:s3/bucketLoggingV2:BucketLoggingV2 example bucket-name
 * ```
 *  If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * ```sh
 *  $ pulumi import aws:s3/bucketLoggingV2:BucketLoggingV2 example bucket-name,123456789012
 * ```
 * @property bucket Name of the bucket.
 * @property expectedBucketOwner Account ID of the expected bucket owner.
 * @property targetBucket Name of the bucket where you want Amazon S3 to store server access logs.
 * @property targetGrants Set of configuration blocks with information for granting permissions. See below.
 * @property targetObjectKeyFormat Amazon S3 key format for log objects. See below.
 * @property targetPrefix Prefix for all log object keys.
 */
public data class BucketLoggingV2Args(
    public val bucket: Output<String>? = null,
    public val expectedBucketOwner: Output<String>? = null,
    public val targetBucket: Output<String>? = null,
    public val targetGrants: Output<List<BucketLoggingV2TargetGrantArgs>>? = null,
    public val targetObjectKeyFormat: Output<BucketLoggingV2TargetObjectKeyFormatArgs>? = null,
    public val targetPrefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketLoggingV2Args> {
    override fun toJava(): com.pulumi.aws.s3.BucketLoggingV2Args =
        com.pulumi.aws.s3.BucketLoggingV2Args.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .expectedBucketOwner(expectedBucketOwner?.applyValue({ args0 -> args0 }))
            .targetBucket(targetBucket?.applyValue({ args0 -> args0 }))
            .targetGrants(
                targetGrants?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .targetObjectKeyFormat(
                targetObjectKeyFormat?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetPrefix(targetPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLoggingV2Args].
 */
@PulumiTagMarker
public class BucketLoggingV2ArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var expectedBucketOwner: Output<String>? = null

    private var targetBucket: Output<String>? = null

    private var targetGrants: Output<List<BucketLoggingV2TargetGrantArgs>>? = null

    private var targetObjectKeyFormat: Output<BucketLoggingV2TargetObjectKeyFormatArgs>? = null

    private var targetPrefix: Output<String>? = null

    /**
     * @param value Name of the bucket.
     */
    @JvmName("gyfikfwikgylbxkc")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Account ID of the expected bucket owner.
     */
    @JvmName("tspmagteihgivont")
    public suspend fun expectedBucketOwner(`value`: Output<String>) {
        this.expectedBucketOwner = value
    }

    /**
     * @param value Name of the bucket where you want Amazon S3 to store server access logs.
     */
    @JvmName("slsdhypnbsulpltk")
    public suspend fun targetBucket(`value`: Output<String>) {
        this.targetBucket = value
    }

    /**
     * @param value Set of configuration blocks with information for granting permissions. See below.
     */
    @JvmName("uticlwrwrnfhlwbo")
    public suspend fun targetGrants(`value`: Output<List<BucketLoggingV2TargetGrantArgs>>) {
        this.targetGrants = value
    }

    @JvmName("lxpnvgvdcamcoymr")
    public suspend fun targetGrants(vararg values: Output<BucketLoggingV2TargetGrantArgs>) {
        this.targetGrants = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks with information for granting permissions. See below.
     */
    @JvmName("diejdwohborsivxl")
    public suspend fun targetGrants(values: List<Output<BucketLoggingV2TargetGrantArgs>>) {
        this.targetGrants = Output.all(values)
    }

    /**
     * @param value Amazon S3 key format for log objects. See below.
     */
    @JvmName("rcuuplngepucaprt")
    public suspend
    fun targetObjectKeyFormat(`value`: Output<BucketLoggingV2TargetObjectKeyFormatArgs>) {
        this.targetObjectKeyFormat = value
    }

    /**
     * @param value Prefix for all log object keys.
     */
    @JvmName("yosowpsyekuxretx")
    public suspend fun targetPrefix(`value`: Output<String>) {
        this.targetPrefix = value
    }

    /**
     * @param value Name of the bucket.
     */
    @JvmName("rdebfirqchxctmri")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Account ID of the expected bucket owner.
     */
    @JvmName("ovhgegrdfjidgjpa")
    public suspend fun expectedBucketOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedBucketOwner = mapped
    }

    /**
     * @param value Name of the bucket where you want Amazon S3 to store server access logs.
     */
    @JvmName("oaorfdxgxsstlhlj")
    public suspend fun targetBucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetBucket = mapped
    }

    /**
     * @param value Set of configuration blocks with information for granting permissions. See below.
     */
    @JvmName("hficlwrwssgpywxv")
    public suspend fun targetGrants(`value`: List<BucketLoggingV2TargetGrantArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGrants = mapped
    }

    /**
     * @param argument Set of configuration blocks with information for granting permissions. See below.
     */
    @JvmName("lvlygimnwahimash")
    public suspend
    fun targetGrants(argument: List<suspend BucketLoggingV2TargetGrantArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketLoggingV2TargetGrantArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetGrants = mapped
    }

    /**
     * @param argument Set of configuration blocks with information for granting permissions. See below.
     */
    @JvmName("lthegsxkoanmywyb")
    public suspend fun targetGrants(
        vararg
        argument: suspend BucketLoggingV2TargetGrantArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketLoggingV2TargetGrantArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetGrants = mapped
    }

    /**
     * @param argument Set of configuration blocks with information for granting permissions. See below.
     */
    @JvmName("ufooxkjgwkcmridm")
    public suspend
    fun targetGrants(argument: suspend BucketLoggingV2TargetGrantArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketLoggingV2TargetGrantArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.targetGrants = mapped
    }

    /**
     * @param values Set of configuration blocks with information for granting permissions. See below.
     */
    @JvmName("fohgjnlrvxqcxffc")
    public suspend fun targetGrants(vararg values: BucketLoggingV2TargetGrantArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetGrants = mapped
    }

    /**
     * @param value Amazon S3 key format for log objects. See below.
     */
    @JvmName("elxgmqlexjtmurbd")
    public suspend fun targetObjectKeyFormat(`value`: BucketLoggingV2TargetObjectKeyFormatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetObjectKeyFormat = mapped
    }

    /**
     * @param argument Amazon S3 key format for log objects. See below.
     */
    @JvmName("vmqwbouoemcdjsnp")
    public suspend
    fun targetObjectKeyFormat(argument: suspend BucketLoggingV2TargetObjectKeyFormatArgsBuilder.() -> Unit) {
        val toBeMapped = BucketLoggingV2TargetObjectKeyFormatArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.targetObjectKeyFormat = mapped
    }

    /**
     * @param value Prefix for all log object keys.
     */
    @JvmName("ywiayblgrntjueiw")
    public suspend fun targetPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPrefix = mapped
    }

    internal fun build(): BucketLoggingV2Args = BucketLoggingV2Args(
        bucket = bucket,
        expectedBucketOwner = expectedBucketOwner,
        targetBucket = targetBucket,
        targetGrants = targetGrants,
        targetObjectKeyFormat = targetObjectKeyFormat,
        targetPrefix = targetPrefix,
    )
}
