@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.BucketMetricFilter
import com.pulumi.aws.s3.kotlin.outputs.BucketMetricFilter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketMetric].
 */
@PulumiTagMarker
public class BucketMetricResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketMetricArgs = BucketMetricArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketMetricArgsBuilder.() -> Unit) {
        val builder = BucketMetricArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BucketMetric {
        val builtJavaResource = com.pulumi.aws.s3.BucketMetric(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketMetric(builtJavaResource)
    }
}

/**
 * Provides a S3 bucket [metrics configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/metrics-configurations.html) resource.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Add metrics configuration for entire S3 bucket
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketMetric;
 * import com.pulumi.aws.s3.BucketMetricArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example");
 *         var example_entire_bucket = new BucketMetric("example-entire-bucket", BucketMetricArgs.builder()
 *             .bucket(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ### Add metrics configuration with S3 object filter
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketMetric;
 * import com.pulumi.aws.s3.BucketMetricArgs;
 * import com.pulumi.aws.s3.inputs.BucketMetricFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example");
 *         var example_filtered = new BucketMetric("example-filtered", BucketMetricArgs.builder()
 *             .bucket(example.id())
 *             .filter(BucketMetricFilterArgs.builder()
 *                 .prefix("documents/")
 *                 .tags(Map.ofEntries(
 *                     Map.entry("priority", "high"),
 *                     Map.entry("class", "blue")
 *                 ))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 bucket metric configurations using `bucket:metric`. For example:
 * ```sh
 *  $ pulumi import aws:s3/bucketMetric:BucketMetric my-bucket-entire-bucket my-bucket:EntireBucket
 * ```
 *
 */
public class BucketMetric internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketMetric,
) : KotlinCustomResource(javaResource, BucketMetricMapper) {
    /**
     * Name of the bucket to put metric configuration.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * [Object filtering](http://docs.aws.amazon.com/AmazonS3/latest/dev/metrics-configurations.html#metrics-configurations-filter) that accepts a prefix, tags, or a logical AND of prefix and tags (documented below).
     */
    public val filter: Output<BucketMetricFilter>?
        get() = javaResource.filter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Unique identifier of the metrics configuration for the bucket. Must be less than or equal to 64 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object BucketMetricMapper : ResourceMapper<BucketMetric> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketMetric::class == javaResource::class

    override fun map(javaResource: Resource): BucketMetric = BucketMetric(
        javaResource as
            com.pulumi.aws.s3.BucketMetric,
    )
}

/**
 * @see [BucketMetric].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketMetric].
 */
public suspend fun bucketMetric(
    name: String,
    block: suspend BucketMetricResourceBuilder.() -> Unit,
): BucketMetric {
    val builder = BucketMetricResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketMetric].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketMetric(name: String): BucketMetric {
    val builder = BucketMetricResourceBuilder()
    builder.name(name)
    return builder.build()
}
