@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.BucketMetricArgs.builder
import com.pulumi.aws.s3.kotlin.inputs.BucketMetricFilterArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketMetricFilterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a S3 bucket [metrics configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/metrics-configurations.html) resource.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Add metrics configuration for entire S3 bucket
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketMetric;
 * import com.pulumi.aws.s3.BucketMetricArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example");
 *         var example_entire_bucket = new BucketMetric("example-entire-bucket", BucketMetricArgs.builder()
 *             .bucket(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ### Add metrics configuration with S3 object filter
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketMetric;
 * import com.pulumi.aws.s3.BucketMetricArgs;
 * import com.pulumi.aws.s3.inputs.BucketMetricFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example");
 *         var example_filtered = new BucketMetric("example-filtered", BucketMetricArgs.builder()
 *             .bucket(example.id())
 *             .filter(BucketMetricFilterArgs.builder()
 *                 .prefix("documents/")
 *                 .tags(Map.ofEntries(
 *                     Map.entry("priority", "high"),
 *                     Map.entry("class", "blue")
 *                 ))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 bucket metric configurations using `bucket:metric`. For example:
 * ```sh
 *  $ pulumi import aws:s3/bucketMetric:BucketMetric my-bucket-entire-bucket my-bucket:EntireBucket
 * ```
 * @property bucket Name of the bucket to put metric configuration.
 * @property filter [Object filtering](http://docs.aws.amazon.com/AmazonS3/latest/dev/metrics-configurations.html#metrics-configurations-filter) that accepts a prefix, tags, or a logical AND of prefix and tags (documented below).
 * @property name Unique identifier of the metrics configuration for the bucket. Must be less than or equal to 64 characters in length.
 */
public data class BucketMetricArgs(
    public val bucket: Output<String>? = null,
    public val filter: Output<BucketMetricFilterArgs>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketMetricArgs> {
    override fun toJava(): com.pulumi.aws.s3.BucketMetricArgs =
        com.pulumi.aws.s3.BucketMetricArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketMetricArgs].
 */
@PulumiTagMarker
public class BucketMetricArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var filter: Output<BucketMetricFilterArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value Name of the bucket to put metric configuration.
     */
    @JvmName("mblhamxqfqsohpwk")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value [Object filtering](http://docs.aws.amazon.com/AmazonS3/latest/dev/metrics-configurations.html#metrics-configurations-filter) that accepts a prefix, tags, or a logical AND of prefix and tags (documented below).
     */
    @JvmName("gatndorhqdpqpxsy")
    public suspend fun filter(`value`: Output<BucketMetricFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value Unique identifier of the metrics configuration for the bucket. Must be less than or equal to 64 characters in length.
     */
    @JvmName("txpkopwnsicbeehy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the bucket to put metric configuration.
     */
    @JvmName("aijyrfisugjxdyor")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value [Object filtering](http://docs.aws.amazon.com/AmazonS3/latest/dev/metrics-configurations.html#metrics-configurations-filter) that accepts a prefix, tags, or a logical AND of prefix and tags (documented below).
     */
    @JvmName("gopnogvgfadcsgua")
    public suspend fun filter(`value`: BucketMetricFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument [Object filtering](http://docs.aws.amazon.com/AmazonS3/latest/dev/metrics-configurations.html#metrics-configurations-filter) that accepts a prefix, tags, or a logical AND of prefix and tags (documented below).
     */
    @JvmName("gjmaeqyckceksxhm")
    public suspend fun filter(argument: suspend BucketMetricFilterArgsBuilder.() -> Unit) {
        val toBeMapped = BucketMetricFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value Unique identifier of the metrics configuration for the bucket. Must be less than or equal to 64 characters in length.
     */
    @JvmName("aefhrhxwvkekenmf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): BucketMetricArgs = BucketMetricArgs(
        bucket = bucket,
        filter = filter,
        name = name,
    )
}
