@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.BucketNotificationLambdaFunction
import com.pulumi.aws.s3.kotlin.outputs.BucketNotificationQueue
import com.pulumi.aws.s3.kotlin.outputs.BucketNotificationTopic
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.s3.kotlin.outputs.BucketNotificationLambdaFunction.Companion.toKotlin as bucketNotificationLambdaFunctionToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketNotificationQueue.Companion.toKotlin as bucketNotificationQueueToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketNotificationTopic.Companion.toKotlin as bucketNotificationTopicToKotlin

/**
 * Builder for [BucketNotification].
 */
@PulumiTagMarker
public class BucketNotificationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketNotificationArgs = BucketNotificationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketNotificationArgsBuilder.() -> Unit) {
        val builder = BucketNotificationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BucketNotification {
        val builtJavaResource = com.pulumi.aws.s3.BucketNotification(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketNotification(builtJavaResource)
    }
}

/**
 * Manages a S3 Bucket Notification Configuration. For additional information, see the [Configuring S3 Event Notifications section in the Amazon S3 Developer Guide](https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html).
 * > **NOTE:** S3 Buckets only support a single notification configuration. Declaring multiple `aws.s3.BucketNotification` resources to the same S3 Bucket will cause a perpetual difference in configuration. See the example "Trigger multiple Lambda functions" for an option.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Add notification configuration to SNS Topic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.s3.BucketNotification;
 * import com.pulumi.aws.s3.BucketNotificationArgs;
 * import com.pulumi.aws.s3.inputs.BucketNotificationTopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucket = new BucketV2("bucket");
 *         final var topicPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("s3.amazonaws.com")
 *                     .build())
 *                 .actions("SNS:Publish")
 *                 .resources("arn:aws:sns:*:*:s3-event-notification-topic")
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("ArnLike")
 *                     .variable("aws:SourceArn")
 *                     .values(bucket.arn())
 *                     .build())
 *                 .build())
 *             .build());
 *         var topicTopic = new Topic("topicTopic", TopicArgs.builder()
 *             .policy(topicPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(topicPolicyDocument -> topicPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var bucketNotification = new BucketNotification("bucketNotification", BucketNotificationArgs.builder()
 *             .bucket(bucket.id())
 *             .topics(BucketNotificationTopicArgs.builder()
 *                 .topicArn(topicTopic.arn())
 *                 .events("s3:ObjectCreated:*")
 *                 .filterSuffix(".log")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Add notification configuration to SQS Queue
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.sqs.QueueArgs;
 * import com.pulumi.aws.s3.BucketNotification;
 * import com.pulumi.aws.s3.BucketNotificationArgs;
 * import com.pulumi.aws.s3.inputs.BucketNotificationQueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucket = new BucketV2("bucket");
 *         final var queuePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions("sqs:SendMessage")
 *                 .resources("arn:aws:sqs:*:*:s3-event-notification-queue")
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("ArnEquals")
 *                     .variable("aws:SourceArn")
 *                     .values(bucket.arn())
 *                     .build())
 *                 .build())
 *             .build());
 *         var queueQueue = new Queue("queueQueue", QueueArgs.builder()
 *             .policy(queuePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(queuePolicyDocument -> queuePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var bucketNotification = new BucketNotification("bucketNotification", BucketNotificationArgs.builder()
 *             .bucket(bucket.id())
 *             .queues(BucketNotificationQueueArgs.builder()
 *                 .queueArn(queueQueue.arn())
 *                 .events("s3:ObjectCreated:*")
 *                 .filterSuffix(".log")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Add notification configuration to Lambda Function
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.lambda.Permission;
 * import com.pulumi.aws.lambda.PermissionArgs;
 * import com.pulumi.aws.s3.BucketNotification;
 * import com.pulumi.aws.s3.BucketNotificationArgs;
 * import com.pulumi.aws.s3.inputs.BucketNotificationLambdaFunctionArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("lambda.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var iamForLambda = new Role("iamForLambda", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var func = new Function("func", FunctionArgs.builder()
 *             .code(new FileArchive("your-function.zip"))
 *             .role(iamForLambda.arn())
 *             .handler("exports.example")
 *             .runtime("go1.x")
 *             .build());
 *         var bucket = new BucketV2("bucket");
 *         var allowBucket = new Permission("allowBucket", PermissionArgs.builder()
 *             .action("lambda:InvokeFunction")
 *             .function(func.arn())
 *             .principal("s3.amazonaws.com")
 *             .sourceArn(bucket.arn())
 *             .build());
 *         var bucketNotification = new BucketNotification("bucketNotification", BucketNotificationArgs.builder()
 *             .bucket(bucket.id())
 *             .lambdaFunctions(BucketNotificationLambdaFunctionArgs.builder()
 *                 .lambdaFunctionArn(func.arn())
 *                 .events("s3:ObjectCreated:*")
 *                 .filterPrefix("AWSLogs/")
 *                 .filterSuffix(".log")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(allowBucket)
 *                 .build());
 *     }
 * }
 * ```
 * ### Trigger multiple Lambda functions
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.lambda.Permission;
 * import com.pulumi.aws.lambda.PermissionArgs;
 * import com.pulumi.aws.s3.BucketNotification;
 * import com.pulumi.aws.s3.BucketNotificationArgs;
 * import com.pulumi.aws.s3.inputs.BucketNotificationLambdaFunctionArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .effect("Allow")
 *             .principals(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .actions("sts:AssumeRole")
 *             .build());
 *         var iamForLambda = new Role("iamForLambda", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var func1 = new Function("func1", FunctionArgs.builder()
 *             .code(new FileArchive("your-function1.zip"))
 *             .role(iamForLambda.arn())
 *             .handler("exports.example")
 *             .runtime("go1.x")
 *             .build());
 *         var bucket = new BucketV2("bucket");
 *         var allowBucket1 = new Permission("allowBucket1", PermissionArgs.builder()
 *             .action("lambda:InvokeFunction")
 *             .function(func1.arn())
 *             .principal("s3.amazonaws.com")
 *             .sourceArn(bucket.arn())
 *             .build());
 *         var func2 = new Function("func2", FunctionArgs.builder()
 *             .code(new FileArchive("your-function2.zip"))
 *             .role(iamForLambda.arn())
 *             .handler("exports.example")
 *             .build());
 *         var allowBucket2 = new Permission("allowBucket2", PermissionArgs.builder()
 *             .action("lambda:InvokeFunction")
 *             .function(func2.arn())
 *             .principal("s3.amazonaws.com")
 *             .sourceArn(bucket.arn())
 *             .build());
 *         var bucketNotification = new BucketNotification("bucketNotification", BucketNotificationArgs.builder()
 *             .bucket(bucket.id())
 *             .lambdaFunctions(
 *                 BucketNotificationLambdaFunctionArgs.builder()
 *                     .lambdaFunctionArn(func1.arn())
 *                     .events("s3:ObjectCreated:*")
 *                     .filterPrefix("AWSLogs/")
 *                     .filterSuffix(".log")
 *                     .build(),
 *                 BucketNotificationLambdaFunctionArgs.builder()
 *                     .lambdaFunctionArn(func2.arn())
 *                     .events("s3:ObjectCreated:*")
 *                     .filterPrefix("OtherLogs/")
 *                     .filterSuffix(".log")
 *                     .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     allowBucket1,
 *                     allowBucket2)
 *                 .build());
 *     }
 * }
 * ```
 * ### Add multiple notification configurations to SQS Queue
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.sqs.QueueArgs;
 * import com.pulumi.aws.s3.BucketNotification;
 * import com.pulumi.aws.s3.BucketNotificationArgs;
 * import com.pulumi.aws.s3.inputs.BucketNotificationQueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucket = new BucketV2("bucket");
 *         final var queuePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions("sqs:SendMessage")
 *                 .resources("arn:aws:sqs:*:*:s3-event-notification-queue")
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("ArnEquals")
 *                     .variable("aws:SourceArn")
 *                     .values(bucket.arn())
 *                     .build())
 *                 .build())
 *             .build());
 *         var queueQueue = new Queue("queueQueue", QueueArgs.builder()
 *             .policy(queuePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(queuePolicyDocument -> queuePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var bucketNotification = new BucketNotification("bucketNotification", BucketNotificationArgs.builder()
 *             .bucket(bucket.id())
 *             .queues(
 *                 BucketNotificationQueueArgs.builder()
 *                     .id("image-upload-event")
 *                     .queueArn(queueQueue.arn())
 *                     .events("s3:ObjectCreated:*")
 *                     .filterPrefix("images/")
 *                     .build(),
 *                 BucketNotificationQueueArgs.builder()
 *                     .id("video-upload-event")
 *                     .queueArn(queueQueue.arn())
 *                     .events("s3:ObjectCreated:*")
 *                     .filterPrefix("videos/")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Emit events to EventBridge
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketNotification;
 * import com.pulumi.aws.s3.BucketNotificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucket = new BucketV2("bucket");
 *         var bucketNotification = new BucketNotification("bucketNotification", BucketNotificationArgs.builder()
 *             .bucket(bucket.id())
 *             .eventbridge(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 bucket notification using the `bucket`. For example:
 * ```sh
 *  $ pulumi import aws:s3/bucketNotification:BucketNotification bucket_notification bucket-name
 * ```
 *
 */
public class BucketNotification internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketNotification,
) : KotlinCustomResource(javaResource, BucketNotificationMapper) {
    /**
     * Name of the bucket for notification configuration.
     * The following arguments are optional:
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Whether to enable Amazon EventBridge notifications. Defaults to `false`.
     */
    public val eventbridge: Output<Boolean>?
        get() = javaResource.eventbridge().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Used to configure notifications to a Lambda Function. See below.
     */
    public val lambdaFunctions: Output<List<BucketNotificationLambdaFunction>>?
        get() = javaResource.lambdaFunctions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        bucketNotificationLambdaFunctionToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Notification configuration to SQS Queue. See below.
     */
    public val queues: Output<List<BucketNotificationQueue>>?
        get() = javaResource.queues().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> bucketNotificationQueueToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Notification configuration to SNS Topic. See below.
     */
    public val topics: Output<List<BucketNotificationTopic>>?
        get() = javaResource.topics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> bucketNotificationTopicToKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object BucketNotificationMapper : ResourceMapper<BucketNotification> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketNotification::class == javaResource::class

    override fun map(javaResource: Resource): BucketNotification = BucketNotification(
        javaResource as
            com.pulumi.aws.s3.BucketNotification,
    )
}

/**
 * @see [BucketNotification].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketNotification].
 */
public suspend fun bucketNotification(
    name: String,
    block: suspend BucketNotificationResourceBuilder.() -> Unit,
): BucketNotification {
    val builder = BucketNotificationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketNotification].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketNotification(name: String): BucketNotification {
    val builder = BucketNotificationResourceBuilder()
    builder.name(name)
    return builder.build()
}
