@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.asset.AssetOrArchive
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [BucketObject].
 */
@PulumiTagMarker
public class BucketObjectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketObjectArgs = BucketObjectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketObjectArgsBuilder.() -> Unit) {
        val builder = BucketObjectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BucketObject {
        val builtJavaResource = com.pulumi.aws.s3.BucketObject(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketObject(builtJavaResource)
    }
}

/**
 * Provides an S3 object resource.
 * ## Example Usage
 * ### Encrypting with KMS Key
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketObject;
 * import com.pulumi.aws.s3.BucketObjectArgs;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var examplekms = new Key("examplekms", KeyArgs.builder()
 *             .description("KMS key 1")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var examplebucket = new BucketV2("examplebucket");
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(examplebucket.id())
 *             .acl("private")
 *             .build());
 *         var exampleBucketObject = new BucketObject("exampleBucketObject", BucketObjectArgs.builder()
 *             .key("someobject")
 *             .bucket(examplebucket.id())
 *             .source(new FileAsset("index.html"))
 *             .kmsKeyId(examplekms.arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Server Side Encryption with S3 Default Master Key
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketObject;
 * import com.pulumi.aws.s3.BucketObjectArgs;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var examplebucket = new BucketV2("examplebucket");
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(examplebucket.id())
 *             .acl("private")
 *             .build());
 *         var exampleBucketObject = new BucketObject("exampleBucketObject", BucketObjectArgs.builder()
 *             .key("someobject")
 *             .bucket(examplebucket.id())
 *             .source(new FileAsset("index.html"))
 *             .serverSideEncryption("aws:kms")
 *             .build());
 *     }
 * }
 * ```
 * ### Server Side Encryption with AWS-Managed Key
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketObject;
 * import com.pulumi.aws.s3.BucketObjectArgs;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var examplebucket = new BucketV2("examplebucket");
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(examplebucket.id())
 *             .acl("private")
 *             .build());
 *         var exampleBucketObject = new BucketObject("exampleBucketObject", BucketObjectArgs.builder()
 *             .key("someobject")
 *             .bucket(examplebucket.id())
 *             .source(new FileAsset("index.html"))
 *             .serverSideEncryption("AES256")
 *             .build());
 *     }
 * }
 * ```
 * ### S3 Object Lock
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketVersioningV2;
 * import com.pulumi.aws.s3.BucketVersioningV2Args;
 * import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs;
 * import com.pulumi.aws.s3.BucketObject;
 * import com.pulumi.aws.s3.BucketObjectArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var examplebucket = new BucketV2("examplebucket", BucketV2Args.builder()
 *             .objectLockEnabled(true)
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(examplebucket.id())
 *             .acl("private")
 *             .build());
 *         var exampleBucketVersioningV2 = new BucketVersioningV2("exampleBucketVersioningV2", BucketVersioningV2Args.builder()
 *             .bucket(examplebucket.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *         var exampleBucketObject = new BucketObject("exampleBucketObject", BucketObjectArgs.builder()
 *             .key("someobject")
 *             .bucket(examplebucket.id())
 *             .source(new FileAsset("important.txt"))
 *             .objectLockLegalHoldStatus("ON")
 *             .objectLockMode("GOVERNANCE")
 *             .objectLockRetainUntilDate("2021-12-31T23:59:60Z")
 *             .forceDestroy(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleBucketVersioningV2)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Import using S3 URL syntax:
 * __Using `pulumi import` to import__ objects using the `id` or S3 URL. For example:
 * Import using the `id`, which is the bucket name and the key together:
 * ```sh
 *  $ pulumi import aws:s3/bucketObject:BucketObject example some-bucket-name/some/key.txt
 * ```
 *  Import using S3 URL syntax:
 * ```sh
 *  $ pulumi import aws:s3/bucketObject:BucketObject example s3://some-bucket-name/some/key.txt
 * ```
 *
 */
public class BucketObject internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketObject,
) : KotlinCustomResource(javaResource, BucketObjectMapper) {
    /**
     * [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Defaults to `private`.
     */
    public val acl: Output<String>?
        get() = javaResource.acl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the bucket to put the file in. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
     */
    public val bucketKeyEnabled: Output<Boolean>
        get() = javaResource.bucketKeyEnabled().applyValue({ args0 -> args0 })

    /**
     * Caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
     */
    public val cacheControl: Output<String>?
        get() = javaResource.cacheControl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.
     */
    public val content: Output<String>?
        get() = javaResource.content().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file.
     */
    public val contentBase64: Output<String>?
        get() = javaResource.contentBase64().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
     */
    public val contentDisposition: Output<String>?
        get() = javaResource.contentDisposition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Content encodings that have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
     */
    public val contentEncoding: Output<String>?
        get() = javaResource.contentEncoding().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Language the content is in e.g., en-US or en-GB.
     */
    public val contentLanguage: Output<String>?
        get() = javaResource.contentLanguage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Standard MIME type describing the format of the object data, e.g., application/octet-stream. All Valid MIME Types are valid for this input.
     */
    public val contentType: Output<String>
        get() = javaResource.contentType().applyValue({ args0 -> args0 })

    /**
     * Triggers updates when the value changes. This attribute is not compatible with KMS encryption, `kms_key_id` or `server_side_encryption = "aws:kms"` (see `source_hash` instead).
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Whether to allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
     */
    public val forceDestroy: Output<Boolean>?
        get() = javaResource.forceDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the object once it is in the bucket.
     * The following arguments are optional:
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * ARN of the KMS Key to use for object encryption. If the S3 Bucket has server-side encryption enabled, that value will automatically be used. If referencing the `aws.kms.Key` resource, use the `arn` attribute. If referencing the `aws.kms.Alias` data source or resource, use the `target_key_arn` attribute. The provider will only perform drift detection if a configuration value is provided.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
     */
    public val metadata: Output<Map<String, String>>?
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * [Legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
     */
    public val objectLockLegalHoldStatus: Output<String>?
        get() = javaResource.objectLockLegalHoldStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
     */
    public val objectLockMode: Output<String>?
        get() = javaResource.objectLockMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Date and time, in [RFC3339 format](https://tools&#46;ietf&#46;org/html/rfc3339#section-5&#46;8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
     */
    public val objectLockRetainUntilDate: Output<String>?
        get() = javaResource.objectLockRetainUntilDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Server-side encryption of the object in S3. Valid values are "`AES256`" and "`aws:kms`".
     */
    public val serverSideEncryption: Output<String>
        get() = javaResource.serverSideEncryption().applyValue({ args0 -> args0 })

    /**
     * Path to a file that will be read and uploaded as raw bytes for the object content.
     */
    public val source: Output<AssetOrArchive>?
        get() = javaResource.source().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Triggers updates like `etag` but useful to address `etag` encryption limitations.
     */
    public val sourceHash: Output<String>?
        get() = javaResource.sourceHash().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * [Storage Class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html#AmazonS3-PutObject-request-header-StorageClass) for the object. Defaults to "`STANDARD`".
     */
    public val storageClass: Output<String>
        get() = javaResource.storageClass().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Unique version ID value for the object, if bucket versioning is enabled.
     */
    public val versionId: Output<String>
        get() = javaResource.versionId().applyValue({ args0 -> args0 })

    /**
     * Target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).
     * If no content is provided through `source`, `content` or `content_base64`, then the object will be empty.
     */
    public val websiteRedirect: Output<String>?
        get() = javaResource.websiteRedirect().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object BucketObjectMapper : ResourceMapper<BucketObject> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketObject::class == javaResource::class

    override fun map(javaResource: Resource): BucketObject = BucketObject(
        javaResource as
            com.pulumi.aws.s3.BucketObject,
    )
}

/**
 * @see [BucketObject].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketObject].
 */
public suspend fun bucketObject(
    name: String,
    block: suspend BucketObjectResourceBuilder.() -> Unit,
): BucketObject {
    val builder = BucketObjectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketObject].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketObject(name: String): BucketObject {
    val builder = BucketObjectResourceBuilder()
    builder.name(name)
    return builder.build()
}
